# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###

proc test_formula {} {
    set x "not ([equiv A B])"
    set y "not A"
    set z "[equiv $y B]"
    return [equiv $z $x]
}

proc test_formula_1 {} {
    set x "[fin_r A]"
    set y "< [true_e] > ( [empty_r] and A )"
    return [equiv $x $y]
}

proc test_formula_2 {} {
    set x "not ( [fin_r A] )"
    set y "not A"
    set z "< [true_e] > ( [empty_r] and $y )"
    return [equiv $x $z]
}

proc test_formula_3 {} {
    set x "<test ( A )> ( true )"
    return [equiv $x A]
}

proc test_formula_4 {} {
    set x "<step ( next A and B imp next (not B) )> ( true )"
    return "$x"
}

proc test_paper {} {
    return "<chopstar(step(A))>(B or C) or <step(A);test(B)>(D)"
}

proc test_paper_1 {} {
    return "(<chopstar(step(A))>(B or C) or <step(A);test(B)>(D)) and <[len_e 4]>[empty_r] "
}

proc test_paper_2 {} {
    return "<chopstar(step(A))>(B) and <[len_e 4]>[empty_r] "
}

proc test_for {} {
    return "[equiv {((P or Q) and P)} P]" 
}

proc test_for_1 {} {
    return "[equiv {<test(A)>(C)} {<test(A) or chopstar(step(false))>(C)} ]" 
}

proc test_always_e {} {
   return "<chopstar(step(A));test(A)>[empty_r] and <[len_e 4]>[empty_r]"
}

proc test_fisher {} {
    return "[imp [and [sometimes_r P]  [always_r [imp P [next_r P]]]] [sometimes_r [always_r P]]]"
}

