# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

###

proc test_formula {} {
    set x "not ([equiv A B])"
    set y "not A"
    set z "[equiv $y B]"
    return [equiv $z $x]
}

proc test_formula_1 {} {
    set x "[fin_l A]"
    set y "( [empty_l] and A ) < [true_l_e] >"
    return [equiv $x $y]
}

proc test_formula_2 {} {
    set x "not ( [fin_l A] )"
    set y "(not A)"
    set z "( [empty_l] and $y ) < [true_l_e] >"
    return [equiv $x $z]
}

proc test_formula_3 {} {
    set x "( true ) <test ( A )> "
    return [equiv $x A]
}

proc test_formula_4 {} {
    set x " ( true ) <sptep ( prev A and B imp prev (not B) )>"
    return "$x"
}

proc test_paper {} {
    return "(B or C)<pchopstar(pstep(A))> or (D)<pstep(A);test(B)>"
}

proc test_paper_1 {} {
    return "((B or C)<pchopstar(pstep(A))> or (D)<pstep(A);test(B)>) and [empty_l]<[len_l_e 4]> "
}

proc test_paper_2 {} {
    return "(B)<pchopstar(pstep(A))> and [empty_l]<[len_l_e 4]> "
}

proc test_for {} {
    return "[equiv {((P or Q) and P)} P]" 
}

proc test_for_1 {} {
    return "[equiv {(C)<test(A)>} {(C)<test(A) or pchopstar(pstep(false))>} ]" 
}

proc test_always_e {} {
   return "[empty_l]<pchopstar(pstep(A));test(A)> and [empty_l]<[len_l_e 4]>"
}

proc test_fisher {} {
    return "[imp [and [sometimes_l P]  [always_l [imp P [prev_l P]]]] [sometimes_l [always_l P]]]"
}

