# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#
#

::bdd_tcl::load_file policy_library.tcl

# token example 
#  In a multi-modal authentication/authorisation scheme a user
#  has to present two tokens (KA and KB) to the
#  access control mechanism in order to gain access to the
#  resource.  The tokens may be presented in any order, at
#  the same time of the request or directly before the access is
#  requested.
#
#  Input Trace:  
#          w_0 w_1 w_2 w_3 w_4 w_5 w_6 
#  A       1   1   1   0   1   0   1
#  KA      1   0   1   1   0   0   1 
#  KB      1   1   0   0   1   0   1 
# 
# In state w_0 access is granted because both keys are available.
# In state w_1 to w_2 the access is allowed, as both KA and KB
# have been available in the current or the previous state.  In state w_3
# the access is denied, as only KA was available in said period. By
# making KB available in state w_4 access is again authorised. In
# state w_5 access is denied, as only key KB is available in the
# history of length 1.  Finally in state w_6 access is allowed again
# as both tokens are available in this state.
#

proc keys {} {
    set p_1 "[true_e];test(KA and KB); step(true);test(true)"  
    set p_2 "[true_e];test(KA and KB)"
    set p_3 "[true_e];test(KA);step(true) ; test(KB)"   
    set p_4 "[true_e];test(KB);step(true) ; test(KA)" 
    set p "($p_1) or ($p_2) or ($p_3) or ($p_4)"
    set w "A"
    set x [r_always_followed_by $p $w]
    return $x
}

# needs to be checked (done by intuition)
proc keys_not {} {
    set p_1 "[true_e];test(not KB);step(true);test(not KB)"
    set p_2 "[true_e];test(not KA);step(true);test(not KA)"
    set p_3 "test( (not KA) and (not KB) )"
    set p "($p_1)  or ($p_2) or ($p_3)"
    set w "(not A)"
    set x [r_always_followed_by $p $w]
    return $x
}

###############################################################

proc input_keys_enf {} {
    return [list "(and KA KB)" \
                "(and (not KA) KB)" \
                "(and KA (not KB))" \
                "(and KA (not KB))" \
                "(and (not KA) KB)" \
                "(and (not KA) (not KB))" \
                "(and KA KB)"]
}


proc test_keys_enf {} {
    global INPUT
    set INPUT [input_keys_enf]
    return "[keys_not] and [keys]"
}






