# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD package
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#
#

::bdd_tcl::load_file policy_library.tcl

# token example 
#  In a multi-modal authentication/authorisation scheme a user
#  has to present two tokens (KA and KB) to the
#  access control mechanism in order to gain access to the
#  resource.  The tokens must be presented in a certain order: 
#  if KB is currently present then 
#      KA should have been present 2*n states (n>=1) before the current state
#   o  o  o  |  o  o  o  o  o | ....
#  KA     KB | KA          KB |
#
#  if KA is currently present then 
#      KB should have been present 1+2*n states (n>=0) before the current state
#   o  o  |  o  o  o  o | ....
#  KB  KA | KB       KA |
#
#  Input Trace:  
#          w_0 w_1 w_2 w_3 w_4 w_5 w_6 
#  A       0   0   1   1   1   0   1
#  KA      1   0   1   1   0   0   1 
#  KB      1   1   0   0   1   0   1 
# 
# In state w_0, access is not granted because 
# KB is currently present but KA was not present an even (not zero) 
# number of states before and 
# KA is currently present but KB was not present an odd 
# number of states before. 
# In state w_1, access is not granted because 
# KB is currently present but KA was not present an even (not zero)
# number of states before. 
# In state w_2, access is allowed because
# KA is currently present and KB was present 1 state before.
# In state w_3, access is allowed because
# KA is currently present and KB was present 3 states before.
# In state w_4, access is allowed because
# KB is currently present and KA was present 2 (and 4) states before.
# In state w_5, access is not allowed because 
# both KA and KB are not currently present.
# In state w_6, access is allowed because
# KA is currently present and KB was present 2 (and 6) states before and
# KB is currently present and KA was present 3 states before.
#

proc keys_left {} {
    set p_1 "true <test(KA); pstep(true);pstep(true); pchopstar(pstep(true);pstep(true));test(KB)>"   
    set p_2 "true <test(KB); pstep(true); pchopstar(pstep(true);pstep(true));test(KA)>" 
    set p "(($p_1) or ($p_2))"
    set w "A" 
    set x [l_always_followed_by $p $w]
    return $x
}

proc keys_not_left {} {
    set p_1 "true <test(KA);pstep(true);pstep(true);pchopstar(pstep(true);pstep(true)); test(KB)>"   
    set p_2 "true <test(KB);pstep(true);pchopstar(pstep(true);pstep(true)); test(KA)>"
    set p "(not(($p_1) or ($p_2)))"
    set w "(not A)"
    set x [l_always_followed_by $p $w]
    return $x
}

###############################################################

proc input_keys_enf {} {
    return [list "(and KA KB)" \
                "(and (not KA) KB)" \
                "(and KA (not KB))" \
                "(and KA (not KB))" \
                "(and (not KA) KB)" \
                "(and (not KA) (not KB))" \
                "(and KA KB)"]
}


proc test_keys_enf_left {} {
    global INPUT
    set INPUT [input_keys_enf]
    return "[keys_not_left] and [keys_left]"
}





