(*  title     : An encoding of ITL in Isabelle/HOL
    Authors   : Antonio Cau     <cau.researcher at gmail.com>
                Ben Moszkowski
                David Smallwood <drs at dmu.ac.uk>
    Maintainer: Antonio Cau     <cau.researcher at gmail.com>        
    License   : BSD
*)

section \<open>Strong chop operator\<close>

theory SChopTheorems
 imports
   Theorems
begin
(*
sledgehammer_params [minimize=true,preplay_timeout=10,timeout=60,verbose=true,
                    provers="z3 cvc4 " ]
*)

(* vampire cvc4 e spass *)

text \<open>
We give the proofs of a list of Finite and Infinite ITL theorems but now using 
the strong chop. 
\<close>

subsection \<open>Strong Chop axioms\<close>

lemma SChopAssoc:
 "\<turnstile> f\<frown>(g\<frown>h) = (f\<frown>g)\<frown>h"
proof -
 have 1: "\<turnstile> f\<frown>(g\<frown>h) = (f \<and> finite);((g \<and> finite);h)"
   by (simp add: schop_d_def) 
 have 2: "\<turnstile> (f \<and> finite);((g \<and> finite);h) = ((f \<and> finite);(g \<and> finite));h"
   using ChopAssoc by blast
 have 3: "\<turnstile> ((f \<and> finite);(g \<and> finite));h = (f\<frown> (g \<and> finite));h"
   by (simp add: schop_d_def)
 have 4: "\<turnstile> f\<frown> (g \<and> finite) = (f\<frown>g \<and> finite)"
   by (simp add: schop_d_def)
      (metis AndChopA ChopAndA ChopAndFiniteDist Prop11 Prop12 inteq_reflection)
 have 5: "\<turnstile> (f\<frown> (g \<and> finite));h = (f\<frown> g \<and> finite);h"
   using "4" by (simp add: LeftChopEqvChop)
 have 6: "\<turnstile> (f\<frown> g \<and> finite);h = (f\<frown>g)\<frown>h"
   by (simp add: schop_d_def) 
 from 1 2 3 5 6 show ?thesis by fastforce
qed

lemma FiniteOr:
 "\<turnstile> ((f \<or> g) \<and> finite) = ((f \<and> finite) \<or> (g \<and> finite))"
by auto

lemma OrSChopImp :
    "\<turnstile> (f \<or> g)\<frown>h   \<longrightarrow>  f\<frown>h \<or> g\<frown>h  "
unfolding  schop_d_def 
by (simp add: FiniteOr OrChopImpRule int_iffD1)

lemma SChopOrImp :
    "\<turnstile>  f\<frown>(g \<or> h) \<longrightarrow>   f\<frown>g \<or>  f\<frown>h "
unfolding  schop_d_def by (simp add: ChopOrImp)

lemma EmptySChop :
    "\<turnstile>  empty \<frown> f = f  "
by (metis EmptyChopSem FiniteAndEmptyEqvEmpty intI inteq_reflection lift_and_com schop_d_def)

lemma SChopEmpty :
    "\<turnstile> finite \<longrightarrow> f\<frown>empty = f  "
unfolding  schop_d_def
proof -
have f1: "\<turnstile>(f \<and> finite);empty = (f \<and> finite)"
  by (simp add: ChopEmpty int_eq)
then show "\<turnstile> finite \<longrightarrow> (f \<and> finite);empty = f"
  by fastforce
qed 

lemma StateImpBf :
    "\<turnstile> init f \<longrightarrow>   bf (init f)  "
unfolding bf_d_def df_d_def schop_d_def
by (metis (no_types) AndChopA StateImpBi bi_d_def di_d_def lift_imp_neg lift_imp_trans) 

lemma BfBoxSChopImpSChop :
    "\<turnstile>  bf ( f \<longrightarrow> f1) \<and> \<box>(g \<longrightarrow> g1) \<longrightarrow> f\<frown>g \<longrightarrow> f1\<frown>g1 "
by (auto simp add: Valid_def itl_defs)


lemma AndMoreSChopEqvAndFmoreChop:
 "\<turnstile> (f \<and> more)\<frown>g = (f \<and> fmore);g"
by (simp add: LeftChopEqvChop AndMoreAndFiniteEqvAndFmore schop_d_def)

lemma FiniteBfGen:
 assumes "\<turnstile> finite \<longrightarrow> f"
 shows   "\<turnstile> bf f"
using assms
by (simp add: Valid_def itl_defs)

(* DR4 *)
lemma BfGen:
 assumes "\<turnstile> f"
 shows   "\<turnstile> bf f"
using assms 
by (metis EmptyImpFinite FiniteAndEmptyEqvEmpty FiniteBfGen Prop09 int_eq_true inteq_reflection)


subsection \<open>ITL operators in terms of SChop\<close>

lemma NextSChopdef:
 "\<turnstile> \<circle> f = skip\<frown>f"
by (metis FiniteChopSkipEqvSkipChopFinite NowImpDiamond Prop10 SkipChopFiniteImpFinite 
    inteq_reflection lift_imp_trans next_d_def schop_d_def sometimes_d_def)

lemma DiamondSChopdef:
 "\<turnstile> \<diamond> f = #True\<frown>f"
by (simp add: schop_d_def sometimes_d_def)

lemma FiniteSChopdef:
 "\<turnstile> finite = \<diamond> empty"
by (simp add: DiamondEmptyEqvFinite int_iffD1 int_iffD2 int_iffI)

lemma ChopSChopdef:
 "\<turnstile> f;g = ((f\<frown>g) \<or> (f \<and> inf))"
by (metis AndInfChopEqvAndInf OrChopEqv OrFiniteInf inteq_reflection schop_d_def)


lemma SFinprop :
 "\<turnstile> ((#True\<frown>(f \<and> empty)) \<and> (#True\<frown>(g \<and> empty))) = (#True\<frown>((f \<and> g) \<and> empty)) "
 "\<turnstile> ((#True\<frown>(f \<and> empty)) \<or> (#True\<frown>(g \<and> empty))) = (#True\<frown>((f \<or> g) \<and> empty)) "
 "\<turnstile>  finite \<longrightarrow> (\<not> (#True\<frown>(f \<and> empty))) = (#True\<frown>(\<not>f \<and> empty))"  
 "\<turnstile> (\<not> (#True\<frown>(f \<and> empty))) = ((#True\<frown>(\<not>f \<and> empty)) \<or> inf)"
by (auto simp add: Valid_def itl_defs  zero_enat_def)
   (metis add.right_neutral enat.distinct(2) enat_add_sub_same less_eqE the_enat.simps zero_enat_def,
    metis ndropn_eq_NNil ndropn_nlast ndropn_nlength nfinite_nlength_enat nlength_NNil the_enat.simps
    zero_enat_def,
   metis add.right_neutral enat.distinct(2) enat_add_sub_same le_iff_add the_enat.simps zero_enat_def,
   metis ndropn_eq_NNil ndropn_nlast ndropn_nlength nfinite_nlength_enat nlength_NNil the_enat.simps 
   zero_enat_def,
   metis add.right_neutral enat.distinct(2) enat_add_sub_same le_iff_add the_enat.simps zero_enat_def,
   metis ndropn_nlength nfinite_ndropn_b nlength_eq_enat_nfiniteD)


subsection \<open>Basic Theorems\<close>

(* T1 *)
lemma BfSChopImpSChop :
    " \<turnstile> bf (f \<longrightarrow> f1) \<longrightarrow> f\<frown>g \<longrightarrow> f1\<frown>g "
proof -
 have  1: "\<turnstile> g \<longrightarrow> g" by auto
 hence 2: "\<turnstile> \<box> ( g \<longrightarrow> g) " by (rule BoxGen)
 have  3: "\<turnstile> bf ( f \<longrightarrow> f1) \<and> \<box>(g \<longrightarrow> g) \<longrightarrow> f\<frown>g \<longrightarrow> f1\<frown>g " by (rule BfBoxSChopImpSChop)
 from 2 3 show ?thesis by fastforce
qed 

lemma BiImpBf:
 "\<turnstile> bi f \<longrightarrow> bf f"
unfolding bi_d_def bf_d_def di_d_def df_d_def schop_d_def
by (simp add: AndChopA) 

lemma BiSChopImpSChop :
    " \<turnstile> bi (f \<longrightarrow> f1) \<longrightarrow> f\<frown>g \<longrightarrow> f1\<frown>g "
proof -
 have  1: "\<turnstile> g \<longrightarrow> g" 
   by auto
 hence 2: "\<turnstile> \<box> ( g \<longrightarrow> g) " 
   by (rule BoxGen)
 have  3: "\<turnstile> bi ( f \<longrightarrow> f1) \<and> \<box>(g \<longrightarrow> g) \<longrightarrow> f\<frown>g \<longrightarrow> f1\<frown>g " 
   using BiImpBf BfBoxSChopImpSChop using BfSChopImpSChop by fastforce
 from 2 3 show ?thesis by fastforce
qed 

(* T14 *)
lemma AndSChopA:
    " \<turnstile> (f \<and> f1)\<frown>g \<longrightarrow> f\<frown>g "
proof -
 have  1: "\<turnstile> f \<and> f1 \<longrightarrow> f" by auto
 hence 2: "\<turnstile> bf (f \<and> f1 \<longrightarrow> f)" by (rule BfGen)
 have  3: "\<turnstile> bf (f \<and> f1 \<longrightarrow> f) \<longrightarrow> (f  \<and> f1)\<frown>g \<longrightarrow> f\<frown>g" by (rule BfSChopImpSChop)
 from 2 3 show ?thesis using MP by blast
qed

(* T15 *)
lemma AndSChopB:
    "\<turnstile> (f \<and> f1)\<frown>g \<longrightarrow> f1\<frown>g "
proof -
 have  1: "\<turnstile> f \<and> f1 \<longrightarrow> f1" by auto
 hence 2: "\<turnstile>  bf (f \<and> f1 \<longrightarrow> f1)" by (rule BfGen)
 have  3: "\<turnstile>  bf (f \<and> f1 \<longrightarrow> f1) \<longrightarrow> (f \<and> f1)\<frown>g \<longrightarrow> f1\<frown>g" by (rule BfSChopImpSChop)
 from 2 3 show ?thesis using MP by blast
qed

(* T48 *)
lemma NextSChop:
  "\<turnstile> (\<circle> f)\<frown>g  = \<circle>(f\<frown>g)"
proof -
 have 1: "\<turnstile> skip\<frown>(f\<frown>g)  = (skip\<frown>f)\<frown>g" by (rule SChopAssoc)
 from 1 show ?thesis using NextSChopdef by (metis inteq_reflection)
qed

(* T2 *)
lemma BoxSChopImpSChop :
    " \<turnstile>  \<box> (g \<longrightarrow> g1) \<longrightarrow> f\<frown>g \<longrightarrow> f\<frown>g1 "
proof -
 have  1: "\<turnstile> g \<longrightarrow> g" by auto
 hence 2: "\<turnstile> bf ( g \<longrightarrow> g) " by (rule BfGen)
 have  3: "\<turnstile> bf ( f \<longrightarrow> f) \<and> \<box>(g \<longrightarrow> g1) \<longrightarrow> f\<frown>g \<longrightarrow> f\<frown>g1 " by (rule BfBoxSChopImpSChop)
 from 2 3 show ?thesis by fastforce
qed 

(* DR5 *)
lemma LeftSChopImpSChop:
 assumes "\<turnstile> f\<longrightarrow> f1" 
 shows   "\<turnstile> f\<frown>g \<longrightarrow> f1\<frown>g"
proof -
 have  1: "\<turnstile> f\<longrightarrow> f1" using assms by auto
 hence 2: "\<turnstile> bf (f \<longrightarrow> f1)" by (rule BfGen)
 have  3: "\<turnstile> bf (f \<longrightarrow> f1) \<longrightarrow> f\<frown>g \<longrightarrow> f1\<frown>g" by (rule BfSChopImpSChop)
 from 2 3 show ?thesis using MP by blast
qed

(* DR9 *)
lemma RightSChopImpSChop:
 assumes "\<turnstile> g \<longrightarrow> g1" 
 shows   "\<turnstile> f\<frown>g \<longrightarrow> f\<frown>g1"
proof -
 have  1: "\<turnstile> g \<longrightarrow> g1" using assms by auto
 hence 2: "\<turnstile> \<box> (g \<longrightarrow> g1)" by (rule BoxGen)
 have  3: "\<turnstile> \<box> (g \<longrightarrow> g1) \<longrightarrow> f\<frown>g \<longrightarrow> f\<frown>g1" by (rule BoxSChopImpSChop)
 from 2 3 show ?thesis using MP by blast
qed
 
(* DR10 *)
lemma RightSChopEqvSChop:
 assumes "\<turnstile> g = g1"
 shows   "\<turnstile> (f\<frown>g) = (f\<frown>g1)"
proof -
 have 1: "\<turnstile> g = g1" using assms by auto
 have 2: "(\<turnstile> g \<longrightarrow> g1) \<Longrightarrow> (\<turnstile> f\<frown>g \<longrightarrow> f\<frown>g1)" by (rule RightSChopImpSChop)
 have 3: "(\<turnstile> g1 \<longrightarrow> g) \<Longrightarrow> (\<turnstile> f\<frown>g1 \<longrightarrow> f\<frown>g)" by (rule RightSChopImpSChop)
 from 1 2 3 show ?thesis by fastforce
qed

(* T3 *)
lemma BoxRightSChopEqvSChop:
  "\<turnstile> \<box> (g = g1) \<longrightarrow>(f\<frown>g) = (f\<frown>g1)"
proof -
 have 0: "\<turnstile> (g = g1) = ( (g \<longrightarrow> g1) \<and>  ( g1 \<longrightarrow> g))" 
   by fastforce
 have 1: "\<turnstile> \<box> (g = g1) = (\<box> (g \<longrightarrow> g1) \<and> \<box> ( g1 \<longrightarrow> g))" 
   by (metis "0" BoxAndBoxEqvBoxRule inteq_reflection)
 have 2: "\<turnstile> \<box> (g \<longrightarrow> g1) \<longrightarrow> (f\<frown>g) \<longrightarrow> (f\<frown>g1)" 
   by (simp add: BoxSChopImpSChop)
 have 3: "\<turnstile> \<box> (g1 \<longrightarrow> g) \<longrightarrow> (f\<frown>g1) \<longrightarrow> (f\<frown>g)" 
   by (simp add: BoxSChopImpSChop)
 from 1 2 3 show ?thesis by fastforce
qed

lemma FiniteRightSChopEqvSChop:
 assumes "\<turnstile> finite \<longrightarrow> g = g1"
 shows   "\<turnstile> finite \<longrightarrow> (f\<frown>g) = (f\<frown>g1)"
using assms unfolding schop_d_def
by (simp add: FiniteRightChopEqvChop)

lemma SChopOrEqv:
 " \<turnstile> f\<frown>(g \<or> g1) = (f\<frown>g \<or> f\<frown>g1) "
proof -
 have  1: "\<turnstile> g \<longrightarrow> g \<or> g1" by auto
 hence 2: "\<turnstile> f\<frown>g \<longrightarrow> f\<frown>(g \<or> g1)" by (rule RightSChopImpSChop)
 have  3: "\<turnstile> g1 \<longrightarrow> g \<or> g1" by auto 
 hence 4: "\<turnstile> f\<frown>g1 \<longrightarrow> f\<frown>(g \<or> g1)" by (rule RightSChopImpSChop)
 from 2 4 show ?thesis by (meson SChopOrImp Prop02 Prop11) 
qed

(* T18 *)
lemma OrSChopEqv:
 " \<turnstile> (f \<or> f1)\<frown>g = (f\<frown>g \<or> f1\<frown>g) "
proof -
 have  1: "\<turnstile> f \<longrightarrow> f \<or> f1" by auto
 hence 2: "\<turnstile> f\<frown>g \<longrightarrow> (f\<or> f1)\<frown>g" by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> f1 \<longrightarrow> f \<or> f1" by auto 
 hence 4: "\<turnstile> f1\<frown>g \<longrightarrow> (f\<or> f1)\<frown>g" by (rule LeftSChopImpSChop)
 from 2 4 show ?thesis 
 by (meson OrSChopImp int_iffI Prop02)
qed

lemma OrSChopImpRule:
 assumes "\<turnstile> f \<longrightarrow> f1 \<or> f2"
 shows   "\<turnstile> f\<frown>g \<longrightarrow> (f1\<frown>g) \<or> (f2\<frown>g)"
proof -
 have  1: "\<turnstile> f \<longrightarrow> f1 \<or> f2" using assms by auto
 hence 2: "\<turnstile> f\<frown>g \<longrightarrow> (f1 \<or> f2)\<frown>g" by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> (f1 \<or> f2)\<frown> g = (f1\<frown>g \<or> f2\<frown>g)" by (rule OrSChopEqv) 
 from 2 3 show ?thesis by fastforce
qed

(* DR6 *)
lemma  LeftSChopEqvSChop:
 assumes "\<turnstile> f = f1"
 shows   "\<turnstile> f\<frown>g = (f1\<frown>g)"
proof -
 have  1: "\<turnstile> f = f1" using assms by auto
 hence 2: "\<turnstile> f \<longrightarrow> f1" by auto
 hence 3: "\<turnstile> f\<frown>g \<longrightarrow> f1\<frown>g" by (rule LeftSChopImpSChop)
 have     "\<turnstile> f1 \<longrightarrow> f" using "1" by auto
 hence 4: "\<turnstile> f1\<frown>g \<longrightarrow> f\<frown>g" by (rule LeftSChopImpSChop)
 from 3 4 show ?thesis by (simp add: int_iffI)
qed

lemma OrSChopEqvRule:
 assumes "\<turnstile> f = (f1 \<or> f2)"
 shows   "\<turnstile> f\<frown>g = ((f1\<frown>g) \<or> (f2\<frown>g))"
proof -
 have  1: "\<turnstile> f = (f1 \<or> f2)" using assms by auto
 hence 2: "\<turnstile> f\<frown>g = ((f1 \<or> f2)\<frown>g)" by (rule LeftSChopEqvSChop) 
 have  3: "\<turnstile> (f1 \<or> f2)\<frown>g = (f1\<frown>g \<or> f2\<frown>g)" by (rule OrSChopEqv)
 from 2 3 show ?thesis by fastforce
qed

lemma SChopOrImpRule:
 assumes " \<turnstile> g \<longrightarrow> g1 \<or> g2"
 shows   " \<turnstile> f\<frown>g \<longrightarrow> (f\<frown>g1) \<or> (f\<frown>g2)"
proof -
 have  1: "\<turnstile> g \<longrightarrow> g1 \<or> g2" using assms by auto
 hence 2: "\<turnstile> f\<frown>g \<longrightarrow> f\<frown>(g1 \<or> g2)" by (rule RightSChopImpSChop)
 have  3: "\<turnstile> f\<frown>(g1 \<or> g2) = (f\<frown>g1 \<or> f\<frown>g2)" by (rule SChopOrEqv)
 from 2 3 show ?thesis by fastforce
qed

(* T21 *)
lemma SChopImpDiamond:
 "\<turnstile> f\<frown>g  \<longrightarrow> \<diamond> g"
proof -
 have  1: "\<turnstile> f  \<longrightarrow> #True" by auto
 hence 2: "\<turnstile> f\<frown>g \<longrightarrow> #True\<frown>g" by (rule LeftSChopImpSChop)
 from 2 show ?thesis using DiamondSChopdef by fastforce
qed

(* T23 *)
lemma BfImpDfImpDf:
  "\<turnstile> bf (f \<longrightarrow> g) \<longrightarrow>  df  f \<longrightarrow>  df  g "
proof -
 have 1: "\<turnstile> bf (f\<longrightarrow> g)  \<longrightarrow> (f\<frown> #True) \<longrightarrow> (g\<frown> #True) "  by (rule BfSChopImpSChop)
 from 1 show ?thesis   by (simp add: df_d_def)
qed

(* DR7 *)
lemma DfImpDf:
 assumes "\<turnstile> f \<longrightarrow> g "
 shows   "\<turnstile>  df  f \<longrightarrow>  df  g "
proof -
 have  1: "\<turnstile> f\<longrightarrow> g " using assms by auto
 hence 2: "\<turnstile> f\<frown> #True \<longrightarrow> g\<frown> #True " by (rule LeftSChopImpSChop)
 from 2 show ?thesis by (simp add: df_d_def)
qed

(* T26 *)
lemma BfImpBfRule:
 assumes "\<turnstile> f \<longrightarrow> g"
 shows   "\<turnstile> bf f \<longrightarrow> bf g "
proof -
 have  1: "\<turnstile> f\<longrightarrow> g" using assms by auto
 hence 2: "\<turnstile> \<not>  g \<longrightarrow> \<not>  f " by auto
 hence 3: "\<turnstile>  df (\<not>  g) \<longrightarrow>  df (\<not>  f) " by (rule DfImpDf)
 hence 4: "\<turnstile> \<not> ( df (\<not>  f)) \<longrightarrow> \<not> ( df (\<not>  g)) " by auto
 from 4 show ?thesis by (simp add: bf_d_def)
qed

(* DR8 *)
lemma DfEqvDf:
 assumes "\<turnstile> f = g "
 shows   "\<turnstile>  df f =  df g "
proof -
 have  1: "\<turnstile> f = g " using assms by auto
 hence 2: "\<turnstile> f\<frown> #True = g\<frown> #True " by (rule LeftSChopEqvSChop)
 from 2 show ?thesis by (simp add: df_d_def)
qed

(* T27 *)
lemma BfEqvBf:
 assumes "\<turnstile> f = g "
 shows   "\<turnstile> bf f =  bf  g "
proof -
 have  1: "\<turnstile> f = g " using assms by auto
 hence 2: "\<turnstile> (\<not>  f) = (\<not>  g) " by auto
 hence 3: "\<turnstile>  df (\<not>  f) =  df (\<not>  g) " by (rule DfEqvDf)
 hence 4: "\<turnstile> (\<not>  (df (\<not>  f))) = (\<not> ( df (\<not>  g))) " by auto
 from 4 show ?thesis by (simp add: bf_d_def)
qed

lemma LeftSChopSChopImpSChopRule:
 assumes "\<turnstile> (f\<frown> g) \<longrightarrow> g "
 shows   "\<turnstile> (f\<frown> g)\<frown> h \<longrightarrow> (g\<frown> h) "
proof -
 have  1: "\<turnstile> (f\<frown> g) \<longrightarrow> g " using assms by blast
 hence 2: "\<turnstile> (f\<frown> g)\<frown> h \<longrightarrow> g\<frown> h " by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> f\<frown> (g\<frown> h) = (f\<frown> g)\<frown> h   " by (rule SChopAssoc) 
 from 2 3 show ?thesis by auto
qed

lemma AndSChopCommute :
 "\<turnstile> (f \<and> f1)\<frown> g = (f1 \<and> f)\<frown> g "
proof -
 have 1: "\<turnstile> (f \<and> f1) = (f1 \<and> f)  " by auto
 from 1 show ?thesis by (rule LeftSChopEqvSChop)
qed

(* T34 *)
lemma BfAndSChopImport:
 "\<turnstile>  bf f \<and> (f1\<frown> g) \<longrightarrow> (f \<and> f1)\<frown>g "
proof -
 have  1: "\<turnstile> f \<longrightarrow> (f1 \<longrightarrow> f\<and> f1) " by auto
 hence 2: "\<turnstile> bf  f \<longrightarrow> bf  (f1 \<longrightarrow> f\<and> f1) " by (rule BfImpBfRule)
 have  3: "\<turnstile> bf  (f1 \<longrightarrow> (f \<and> f1)) \<longrightarrow>   f1\<frown> g \<longrightarrow> (f \<and> f1)\<frown> g " by (rule BfSChopImpSChop)
 from 2 3 show ?thesis using MP by fastforce
qed

lemma BiAndSChopImport:
 "\<turnstile>  bi f \<and> (f1\<frown> g) \<longrightarrow> (f \<and> f1)\<frown>g "
proof -
 have  1: "\<turnstile> f \<longrightarrow> (f1 \<longrightarrow> f \<and> f1) " by auto
 hence 2: "\<turnstile> bi  f \<longrightarrow> bi  (f1 \<longrightarrow> f\<and> f1) " by (rule BiImpBiRule)
 have  3: "\<turnstile> bi  (f1 \<longrightarrow> (f \<and> f1)) \<longrightarrow>   f1\<frown> g \<longrightarrow> (f \<and> f1)\<frown> g " by (rule BiSChopImpSChop)
 from 2 3 show ?thesis using MP by fastforce
qed

(* T40 *)
lemma StateAndSChopImport:
 "\<turnstile> (init w) \<and> (f\<frown>g) \<longrightarrow> ((init w) \<and> f)\<frown>g "
proof -
 have  1: "\<turnstile> (init w)\<longrightarrow> bf  (init w) " by (rule StateImpBf)
 hence 2: "\<turnstile> (init w) \<and> (f\<frown> g) \<longrightarrow> bf (init w) \<and> (f\<frown> g) " by auto
 have  3: "\<turnstile> bf  (init w) \<and> (f\<frown> g) \<longrightarrow> ((init w) \<and> f)\<frown> g "  by (rule BfAndSChopImport)
 from 2 3 show ?thesis using MP by fastforce
qed


subsection \<open>Further Properties Df and Bf\<close>

lemma AndFiniteImpDf:
 "\<turnstile> f \<and> finite \<longrightarrow>  df  f "
proof -
 have  1: "\<turnstile> finite \<longrightarrow> f\<frown> empty  = f " by (rule SChopEmpty)
 have  2: "\<turnstile> empty  \<longrightarrow> #True " by auto
 hence 3: "\<turnstile> f\<frown>  empty  \<longrightarrow> f\<frown> #True " by (rule RightSChopImpSChop)
 have 4 : "\<turnstile> f \<and> finite \<longrightarrow> f\<frown> #True " using "1" "3" by fastforce
 from 4 show ?thesis by (simp add: df_d_def)
qed

(* T36 *)
lemma DfState:
 "\<turnstile> df (init w) = (init w)"
proof -
 have  0: "\<turnstile> (init (\<not>w)) \<longrightarrow> bf   (init (\<not>w)) " using StateImpBf by fastforce
 hence 1: "\<turnstile> \<not>(init w) \<longrightarrow> bf ( \<not> (init w))" using Initprop(2) by (metis inteq_reflection)
 hence 2: "\<turnstile> (\<not>  (init w)) \<longrightarrow> \<not> ( df (\<not> \<not>  (init w))) " by (simp add: bf_d_def)
 have  3: "\<turnstile> (\<not>  (init w) \<longrightarrow>\<not> (df (\<not>\<not>(init w)))) \<longrightarrow> ( df (\<not>\<not>(init w)) \<longrightarrow> (init w)) " by auto
 have  4: "\<turnstile>  df (\<not> \<not>  (init w)) \<longrightarrow> (init w) " using "2" "3" MP by blast
 have  5: "\<turnstile> (init w) \<longrightarrow> \<not> \<not>  (init w) " by auto
 hence 6: "\<turnstile>  df  (init w) \<longrightarrow>  df (\<not> \<not>  (init w)) " by (rule DfImpDf) 
 have  7: "\<turnstile>  df  (init w) \<longrightarrow> (init w)" using "6" "4" using lift_imp_trans by metis
 have  8: "\<turnstile> (init w) \<and> finite \<longrightarrow>  df  (init w) " by (rule AndFiniteImpDf)
 from 7 8 show ?thesis 
   by (metis NowImpDiamond Prop10 StateAndChop df_d_def int_simps(17) inteq_reflection 
       lift_and_com schop_d_def sometimes_d_def)
qed

(* T 38 *)
lemma StateSChop:
 "\<turnstile> (init w)\<frown> f \<longrightarrow> (init w) "
by (simp add: StateChopExportA schop_d_def)

(* T39 *)
lemma StateSChopExportA:
 "\<turnstile> ((init w) \<and> f)\<frown> g \<longrightarrow> (init w) "
by (meson AndSChopA StateSChop lift_imp_trans)

(* T41 *)
lemma StateAndSChop:
 "\<turnstile> ((init w) \<and> f)\<frown> g = ((init w) \<and> (f\<frown> g)) "
by (simp add: AndSChopB StateAndSChopImport StateSChopExportA Prop11 Prop12)
 
lemma StateAndSChopImpSChopRule:
 assumes "\<turnstile> (init w) \<and> f \<longrightarrow> f1 " 
 shows   "\<turnstile> (init w) \<and> (f\<frown> g) \<longrightarrow> (f1\<frown> g) "
proof -
 have  1: "\<turnstile> (init w) \<and> f \<longrightarrow> f1 " using assms by auto
 hence 2: "\<turnstile> ((init w) \<and> f)\<frown> g \<longrightarrow> f1\<frown> g " by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> ((init w) \<and> f)\<frown> g = ((init w) \<and> (f\<frown> g)) " by (rule StateAndSChop)
 from 2 3 show ?thesis by fastforce
qed

lemma StateImpSChopEqvSChop :
 assumes "\<turnstile> (init w) \<longrightarrow> (f = f1)" 
 shows   "\<turnstile> (init w) \<longrightarrow> ((f\<frown> g) = (f1\<frown> g)) "
proof -
 have  1: "\<turnstile> (init w) \<longrightarrow> (f= f1)" using assms by auto
 hence 2: "\<turnstile> (init w) \<and> f \<longrightarrow> f1 " by auto
 hence 3: "\<turnstile> (init w) \<and> (f\<frown> g) \<longrightarrow> (f1\<frown> g) " by (rule StateAndSChopImpSChopRule)
 have  4: "\<turnstile> (init w) \<and> f1 \<longrightarrow> f " using "1" by auto
 hence 5: "\<turnstile> (init w) \<and> (f1\<frown> g) \<longrightarrow> (f\<frown> g)" by (rule StateAndSChopImpSChopRule)
 from 3 5 show ?thesis by fastforce
qed

lemma ChopEqvStateAndSChop:
  assumes "\<turnstile> f = (init w) \<and> f1 "
  shows   "\<turnstile> (f\<frown> g) = ((init w) \<and> (f1\<frown> g)) "
proof -
 have  1: "\<turnstile> f = ((init w) \<and> f1) " using assms by auto
 hence 2: "\<turnstile> f\<frown> g = (((init w) \<and> f1)\<frown> g) " by (rule LeftSChopEqvSChop)
 have  3: "\<turnstile> ((init w) \<and> f1)\<frown> g = ((init w) \<and> (f1\<frown> g)) " by (rule StateAndSChop)
 from 2 3 show ?thesis by fastforce
qed

lemma DfIntro:
 "\<turnstile> f \<and> finite \<longrightarrow>  df  f "
proof -
  have  1: "\<turnstile> finite \<longrightarrow> f\<frown>empty  = f " by (rule SChopEmpty)
  have  2: "\<turnstile>  empty  \<longrightarrow> #True " by auto
  hence 3: "\<turnstile> \<box>( empty  \<longrightarrow> #True)" by (rule BoxGen)
  have  4: "\<turnstile> \<box>( empty  \<longrightarrow> #True) \<longrightarrow>  (f;  empty  \<longrightarrow> f; #True) " by (rule BoxChopImpChop)
  have  5: "\<turnstile> f\<frown>empty  \<longrightarrow> f\<frown>#True " using "3" "4" MP by (simp add: RightSChopImpSChop)
  hence 6: "\<turnstile> f\<frown>empty  \<longrightarrow>  df  f"  by (simp add: df_d_def)
  from 1 6 show ?thesis using AndFiniteImpDf by blast
qed

lemma BfElim:
 "\<turnstile>   bf f \<and> finite \<longrightarrow> f "
proof - 
  have  1: "\<turnstile> \<not>f \<and> finite \<longrightarrow>  df (\<not>f) " by (rule DfIntro)
  have  2: "\<turnstile> (\<not>f \<and> finite \<longrightarrow>  df (\<not>f)) \<longrightarrow> (\<not>(df (\<not>f)) \<longrightarrow> \<not>(\<not> f \<and> finite) ) "  by simp
  have 21: "\<turnstile> \<not>(\<not> f \<and> finite) = (f \<or> inf)" by (simp add: Valid_def finite_d_def)
  have  3: "\<turnstile> \<not>  (df (\<not>f)) \<longrightarrow> f \<or> inf" using 1 2 21 by fastforce
  from 3 show ?thesis by (simp add: Prop13 bf_d_def finite_d_def)
qed

(* T24 *)
lemma BfContraPosImpDist:
  "\<turnstile> bf (\<not>g \<longrightarrow> \<not>f) \<longrightarrow> (bf f) \<longrightarrow> (bf g) "
proof -
  have  1: "\<turnstile> bf (\<not>g \<longrightarrow> \<not>f) \<longrightarrow> (df (\<not>g)) \<longrightarrow> (df (\<not>f)) " by (rule BfImpDfImpDf)
  hence 2: "\<turnstile> bf (\<not>g \<longrightarrow> \<not>f) \<longrightarrow> (\<not>( df (\<not>f))) \<longrightarrow> (\<not>(df (\<not>g))) " by auto
  from 2 show ?thesis by (metis bf_d_def)
qed

(* T25 *)
lemma BfImpDist:
 "\<turnstile> bf (f\<longrightarrow> g) \<longrightarrow> (bf f) \<longrightarrow> (bf g) "
proof -
 have  1: "\<turnstile> (f \<longrightarrow> g) \<longrightarrow> (\<not>  g \<longrightarrow> \<not>  f) " by auto
 hence 2: "\<turnstile> \<not> (\<not>  g \<longrightarrow> \<not>  f) \<longrightarrow> \<not> (f \<longrightarrow> g) " by auto
 hence 3: "\<turnstile> bf (\<not> (\<not>  g \<longrightarrow> \<not>  f) \<longrightarrow> \<not> (f \<longrightarrow> g)) " by (rule BfGen)
 have  4: "\<turnstile> bf (\<not> (\<not>  g \<longrightarrow> \<not>  f) \<longrightarrow> \<not> (f \<longrightarrow> g))
             \<longrightarrow>  
             bf (f \<longrightarrow> g) \<longrightarrow> bf (\<not>  g \<longrightarrow> \<not>  f) " by (rule BfContraPosImpDist)
 have  5: "\<turnstile> bf (f \<longrightarrow> g) \<longrightarrow> bf (\<not>  g \<longrightarrow> \<not>  f) " using 3 4 MP by blast
 have  6: "\<turnstile> bf (\<not>  g \<longrightarrow> \<not>  f) \<longrightarrow> (bf  f) \<longrightarrow> (bf  g) " by (rule BfContraPosImpDist)
 from 5 6 show ?thesis  using lift_imp_trans by blast 
qed

(* DR59 *)
lemma FiniteImpBfImpBfRule:
 assumes "\<turnstile> finite \<longrightarrow> (f \<longrightarrow> g)"
 shows   "\<turnstile> bf f \<longrightarrow> bf g "
proof -
 have  1: "\<turnstile> finite \<longrightarrow> f\<longrightarrow> g" using assms by auto
 have  2: "\<turnstile> bf(f \<longrightarrow> g)" using "1" by (simp add: FiniteBfGen)
 have  3: "\<turnstile>  bf(f \<longrightarrow> g) \<longrightarrow> bf f \<longrightarrow> bf g" using BfImpDist by blast
 from 2 3 show ?thesis by fastforce
qed

(* DR60 *)
lemma FiniteImpBfEqvRule:
 assumes "\<turnstile> finite \<longrightarrow> (f = g)"
 shows   "\<turnstile> bf f = bf g"
proof -
 have 1: "\<turnstile> finite \<longrightarrow> (f = g)" using assms by blast
 have 2: "\<turnstile> finite \<longrightarrow> (f \<longrightarrow> g)" using "1" by auto
 have 3: "\<turnstile> bf f \<longrightarrow> bf g" by (simp add: "2" FiniteImpBfImpBfRule)
 have 4: "\<turnstile> finite \<longrightarrow> (g \<longrightarrow> f)" using "1" by auto
 have 5: "\<turnstile> bf g \<longrightarrow> bf f" by (simp add: "4" FiniteImpBfImpBfRule) 
 from 3 5 show ?thesis by fastforce
qed

lemma IfSChopEqvRule:
 assumes "\<turnstile> f =  if\<^sub>i  (init w)  then  f1  else  f2 "
 shows   "\<turnstile> f\<frown> g =  if\<^sub>i  (init w)  then  (f1\<frown> g)  else  (f2\<frown> g) "
proof -
 have  1: "\<turnstile> f =  if\<^sub>i  (init w)  then  f1  else  f2" 
   using assms by auto
 hence 2: "\<turnstile> f = (((init w) \<and> f1) \<or>  ( (init (\<not> w)) \<and> f2)) " 
   unfolding ifthenelse_d_def by (metis Initprop(2) int_eq) 
 hence 3: "\<turnstile> f\<frown> g = (((init w) \<and> f1)\<frown> g \<or>  (  (init (\<not> w)) \<and> f2)\<frown> g) " 
   by (rule OrSChopEqvRule)
 have  4: "\<turnstile> ((init w) \<and> f1)\<frown> g = ((init w) \<and> (f1\<frown> g)) " 
   by (rule StateAndSChop)
 have  5: "\<turnstile> (  (init (\<not> w)) \<and> f2)\<frown> g =   ((init (\<not> w)) \<and> (f2\<frown> g)) " 
   by (rule StateAndSChop)
 have  6: "\<turnstile> f\<frown> g = (((init w) \<and> f1\<frown> g)  \<or>  (  (init (\<not> w)) \<and> f2\<frown> g)) " 
   using "3" "4" "5" by fastforce
 from 6 show ?thesis unfolding ifthenelse_d_def by (metis Initprop(2) inteq_reflection) 
qed

lemma SChopOrEqvRule:
 assumes "\<turnstile> g = (g1 \<or>  g2) "
 shows   "\<turnstile> f\<frown>g = ((f\<frown>g1) \<or>  (f\<frown>g2)) "
proof -
 have  1: "\<turnstile> g = (g1 \<or>  g2) " using assms by auto
 hence 2: "\<turnstile> f\<frown> g = (f\<frown> (g1 \<or>  g2)) " by (rule RightSChopEqvSChop)
 have  3: "\<turnstile> f\<frown> (g1 \<or>  g2) = (f\<frown> g1 \<or>  f\<frown> g2) " by (rule SChopOrEqv)
 from 2 3 show ?thesis by fastforce
qed

lemma EmptyOrSChopEqv: 
 "\<turnstile> ( empty  \<or>  f)\<frown> g = (g \<or>  (f\<frown> g)) "
proof -
 have 1: "\<turnstile> ( empty  \<or>  f)\<frown> g = (( empty \<frown> g) \<or>  (f\<frown> g)) " by (rule OrSChopEqv)
 have 2: "\<turnstile>  empty \<frown> g = g " by (rule EmptySChop)
 from 1 2 show ?thesis by fastforce
qed

lemma EmptyOrNextSChopEqv:
  "\<turnstile> ( empty  \<or>  \<circle> f)\<frown> g = (g \<or>  \<circle>(f\<frown> g)) "
proof -
 have 1: "\<turnstile> ( empty  \<or>  \<circle> f)\<frown> g = (g \<or>  ((\<circle> f)\<frown> g)) " by (rule EmptyOrSChopEqv)
 have 2: "\<turnstile> (\<circle> f)\<frown> g = \<circle>(f\<frown> g) " by (rule NextSChop)
 from 1 2 show ?thesis by fastforce
qed

lemma EmptyOrSChopImpRule:
 assumes "\<turnstile>   f \<longrightarrow>  empty  \<or>  f1 " 
 shows   "\<turnstile> f\<frown> g \<longrightarrow> g \<or>  (f1\<frown> g) " 
proof -
 have  1: "\<turnstile> f \<longrightarrow>  empty  \<or>  f1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> ( empty  \<or>  f1)\<frown> g " by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> ( empty  \<or>  f1)\<frown> g = (g \<or>  (f1\<frown> g)) " by (rule EmptyOrSChopEqv)
 from 2 3 show ?thesis by fastforce
qed

lemma EmptyOrSChopEqvRule:
 assumes "\<turnstile>   f =  (empty  \<or>  f1) "
 shows   "\<turnstile> f\<frown> g = (g \<or>  (f1\<frown> g)) "
proof -
 have  1: "\<turnstile> f =  (empty  \<or>  f1)  " using assms by auto
 hence 2: "\<turnstile> f\<frown> g = (( empty  \<or>  f1)\<frown> g) " by (rule LeftSChopEqvSChop)
 have  3: "\<turnstile> ( empty  \<or>  f1)\<frown> g = (g \<or>  (f1\<frown> g))" by (rule EmptyOrSChopEqv)
 from 2 3 show ?thesis by fastforce
qed

lemma EmptyOrNextSChopImpRule:
 assumes "\<turnstile> f \<longrightarrow>  empty  \<or>  \<circle> f1 "
 shows   "\<turnstile> f\<frown> g \<longrightarrow> g \<or>  \<circle>(f1\<frown> g) "
proof -
 have  1: "\<turnstile> f \<longrightarrow>  empty  \<or>  \<circle> f1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> ( empty  \<or>  \<circle> f1)\<frown> g " by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> ( empty  \<or>  \<circle> f1)\<frown> g = (g \<or>  \<circle>(f1\<frown> g)) " by (rule EmptyOrNextSChopEqv)
 from 2 3 show ?thesis by fastforce
qed

lemma EmptyOrNextSChopEqvRule:
 assumes "\<turnstile> f =  (empty  \<or>  \<circle> f1) "
 shows   "\<turnstile> f\<frown> g = (g \<or>  \<circle>(f1\<frown> g)) "
proof -
 have  1: "\<turnstile> f =  (empty  \<or>  \<circle> f1) " using assms by auto
 hence 2: "\<turnstile> f\<frown> g = (( empty  \<or>  \<circle> f1)\<frown> g) " by (rule LeftSChopEqvSChop)
 have  3: "\<turnstile> ( empty  \<or>  \<circle> f1)\<frown> g = (g \<or>  \<circle>(f1\<frown> g)) " by (rule EmptyOrNextSChopEqv)
 from 2 3 show ?thesis by fastforce
qed

lemma SChopEmptyOrImpRule:
 assumes "\<turnstile>  g \<longrightarrow>  empty  \<or>  g1 "
 shows "\<turnstile> f\<frown> g \<and> finite \<longrightarrow> f \<or>  (f\<frown> g1) "
proof -
 have  1: "\<turnstile> g \<longrightarrow>  empty  \<or>  g1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> (f\<frown>  empty ) \<or>  (f\<frown> g1) " by (rule SChopOrImpRule)
 have  3: "\<turnstile> finite \<longrightarrow> f\<frown>  empty  = f " by (rule SChopEmpty)
 from 2 3 show ?thesis by fastforce
qed

lemma BoxStateSChopBoxAndInfImpBox:
 "\<turnstile> \<box> (init w)\<frown> \<box> (init w) \<and> inf \<longrightarrow> \<box> (init w)"
 by (metis AndChopA BoxStateChopBoxEqvBox OrFiniteInf Prop03 int_eq lift_imp_trans schop_d_def)

lemma BoxStateSChopBoxEqvBox:
 "\<turnstile>   \<box> (init w)\<frown> \<box> (init w) = \<box> (init w) "
proof -
 have   1: "\<turnstile> (\<box> (init w)) = ((init w) \<and> ( empty  \<or>  \<circle>(\<box> (init w)))) " 
   by (rule BoxEqvAndEmptyOrNextBox)
 hence  2: "\<turnstile> (\<box> (init w)\<frown> \<box> (init w)) =
               ((init w) \<and> (( empty  \<or>  \<circle>(\<box> (init w)))\<frown> \<box> (init w))) " 
   by (metis StateAndSChop inteq_reflection)
 have   3: "\<turnstile> (( empty  \<or>  \<circle>(\<box> (init w)))\<frown> \<box> (init w)) =
              (\<box> (init w) \<or>  \<circle>(\<box> (init w)\<frown> \<box> (init w))) " 
   by (rule EmptyOrNextSChopEqv)
 have   4: "\<turnstile> (\<box> (init w)\<frown> \<box> (init w)) = 
              ((init w) \<and> (\<box> (init w) \<or>  \<circle>(\<box> (init w)\<frown> \<box> (init w)))) " 
   using "2" "3" by fastforce
 have   5: "\<turnstile> \<not> (\<box> (init w)) \<longrightarrow> \<not>  (init w) \<or>  \<not>( \<circle>(\<box> (init w))) " 
   by (rule NotBoxImpNotOrNotNextBox)
 have   6: "\<turnstile> (\<box> (init w)\<frown> \<box> (init w)) \<and> \<not>( \<box> (init w)) \<longrightarrow>
              \<circle>(\<box> (init w)\<frown> \<box> (init w)) \<and> \<not>( \<circle>(\<box> (init w)))  " 
   using "4" "5" by fastforce
 hence  7: "\<turnstile> \<box> (init w)\<frown> \<box> (init w) \<and> finite \<longrightarrow> \<box> (init w) " 
   by (rule NextContra) 
 have   8: "\<turnstile> \<box> (init w)\<frown> \<box> (init w) \<and> inf \<longrightarrow> \<box> (init w)"
   by (rule BoxStateSChopBoxAndInfImpBox)
 have   9: "\<turnstile> \<box> (init w)\<frown> \<box> (init w) \<and> (finite \<or> inf) \<longrightarrow> \<box> (init w)"
   using "7" "8"  by fastforce
 hence  10: "\<turnstile>  \<box> (init w)\<frown> \<box> (init w) \<longrightarrow> \<box> (init w)"
   using FiniteOrInfinite by fastforce  
 have  11: "\<turnstile> \<box> (init w) = ((init w) \<and> \<box> (init w)) " 
   by (rule BoxEqvAndBox)
 have  12: "\<turnstile> empty \<frown> \<box> (init w) = \<box> (init w)" 
   by (rule EmptySChop)
 have  13: "\<turnstile> ((init w) \<and>  empty )\<frown> \<box> (init w) = ((init w) \<and> ( empty \<frown> \<box> (init w))) " 
   by (rule StateAndSChop)
 have  14: "\<turnstile> \<box> (init w) = ((init w) \<and>  empty )\<frown> \<box> (init w) " 
   using "11" "12" "13" by fastforce
 have  15: "\<turnstile> (init w) \<and>  empty  \<longrightarrow> \<box> (init w) " 
   by (rule StateAndEmptyImpBoxState)
 hence 16: "\<turnstile> ((init w) \<and>  empty )\<frown> \<box> (init w) \<longrightarrow> \<box> (init w)\<frown> \<box> (init w) " 
   by (rule LeftSChopImpSChop)
 have  17: "\<turnstile> \<box> (init w) \<longrightarrow> \<box> (init w)\<frown> \<box> (init w)" 
   using "14" "16" by fastforce
 from 10 17 show ?thesis by fastforce
qed

lemma NotBoxStateImpBoxSYieldsNotBox:
 "\<turnstile>   \<not>( \<box> (init w)) \<longrightarrow> (\<box> (init w)) syields (\<not>( \<box> (init w)))"
proof -
 have  1: "\<turnstile> \<box> (init w)\<frown> \<box> (init w) = \<box> (init w) " by (rule BoxStateSChopBoxEqvBox)
 have  2: "\<turnstile> \<box> (init w) = (\<not> \<not>( \<box> (init w))) " by auto
 hence 3: "\<turnstile> \<box> (init w)\<frown>\<box>(init w) = \<box>(init w)\<frown> (\<not>\<not>(\<box>(init w))) " by (rule RightSChopEqvSChop)
 have  4: "\<turnstile> \<not>( \<box> (init w)) \<longrightarrow> \<not> (\<box> (init w)\<frown> (\<not> \<not> (\<box> (init w)))) " using "1" "3" by auto
 from 4 show ?thesis by (simp add: syields_d_def)
qed

(* T37 *)
lemma StateEqvBf:
 "\<turnstile>   (init w) = bf  (init w) "
proof -
  have 1: "\<turnstile> (init w) \<longrightarrow> bf  (init w) " by (rule StateImpBf)
  have 2: "\<turnstile> bf  (init w) \<and> finite \<longrightarrow> (init w)" by (rule BfElim)
  from 1 2 show ?thesis
  by (metis (no_types) DfState Initprop(2) bf_d_def int_simps(4) inteq_reflection)
qed

lemma TrueSChopEqvDiamond:
 "\<turnstile>   #True\<frown> f = \<diamond> f"
using DiamondSChopdef by fastforce

(* T28 *)
lemma BfAndEqvBfAndBf:
 "\<turnstile> bf(f \<and> g) = (bf f \<and> bf g)"
proof -
 have 1: "\<turnstile> f \<and> g \<longrightarrow> f" by auto
 have 2: "\<turnstile> bf(f \<and> g) \<longrightarrow> bf f" by (simp add: "1" BfImpBfRule)
 have 3: "\<turnstile> f \<and> g \<longrightarrow> g" by auto
 have 4: "\<turnstile> bf(f \<and> g) \<longrightarrow> bf g" by (simp add: "3" BfImpBfRule)
 have 5: "\<turnstile> f \<longrightarrow> (g \<longrightarrow> f \<and> g)" by auto
 have 6: "\<turnstile> bf f \<longrightarrow> bf (g \<longrightarrow> f \<and> g)" by (simp add: "5" BfImpBfRule)
 have 7: "\<turnstile> bf (g \<longrightarrow> f \<and> g) \<longrightarrow> (bf g \<longrightarrow> bf(f \<and> g))" by (simp add: BfImpDist)
 have 8: "\<turnstile> bf f \<and> bf g \<longrightarrow> bf (f \<and> g)" using "6" "7" by fastforce
 from 2 4 8 show ?thesis by fastforce
qed

(* T29 *)
lemma BfEqvBfImpAndBfImp:
 "\<turnstile> bf(f = g) = (bf (f \<longrightarrow> g) \<and> bf(g \<longrightarrow> f))"
proof -
 have 1: "\<turnstile> (f = g) = ((f \<longrightarrow> g) \<and> (g \<longrightarrow> f))" by auto
 have 2: "\<turnstile> bf(f = g) = bf((f \<longrightarrow> g) \<and> (g \<longrightarrow> f))" by (simp add: "1" BfEqvBf) 
 have 3: "\<turnstile> bf((f \<longrightarrow> g) \<and> (g \<longrightarrow> f)) = (bf(f \<longrightarrow> g) \<and> bf(g \<longrightarrow> f))" by (simp add: BfAndEqvBfAndBf) 
 from 2 3 show ?thesis by fastforce
qed

(* T30 *)
lemma BfEqvImpSChopEqvSChop:
 "\<turnstile> bf(f = f1) \<longrightarrow> f\<frown>g = f1 \<frown> g"
proof -
 have 1: "\<turnstile> bf(f = f1) = (bf (f \<longrightarrow> f1) \<and> bf(f1 \<longrightarrow> f))" by (simp add: BfEqvBfImpAndBfImp)
 have 2: "\<turnstile> bf (f \<longrightarrow> f1) \<longrightarrow> f \<frown> g \<longrightarrow> f1 \<frown> g" by (simp add: BfSChopImpSChop)
 have 3: "\<turnstile> bf(f1 \<longrightarrow> f) \<longrightarrow> f1 \<frown> g \<longrightarrow> f \<frown> g" by (simp add: BfSChopImpSChop)
 from 1 2 3 show ?thesis by fastforce
qed

(* T31 *)
lemma BfEqvDfEqvDf:
 "\<turnstile> bf(f = g) \<longrightarrow> (df f = df g)"
proof -
 have 1: "\<turnstile> bf(f = g) \<longrightarrow> (f \<frown> #True) = (g \<frown> #True)" 
   using BfEqvImpSChopEqvSChop by fastforce
 from 1 show ?thesis by (simp add: df_d_def)
qed

(* T32 *)
lemma FiniteImpEqvDfImpRule:
 assumes "\<turnstile> finite \<longrightarrow> f = g"
 shows   "\<turnstile> df f = df g"
proof -
 have 1: "\<turnstile> finite \<longrightarrow> f = g" using assms by auto
 have 2: "\<turnstile> bf(f = g) " using "1" by (simp add: FiniteBfGen)
 have 3: "\<turnstile>  bf(f = g) \<longrightarrow> (df f = df g)" by (simp add: BfEqvDfEqvDf)
 from 2 3 show ?thesis by fastforce
qed
 
(* T20 *)
lemma DfEmpty:
 "\<turnstile>    df  empty "
proof -
 have 1: "\<turnstile> #True  " by auto
 have 2: "\<turnstile>  empty \<frown> #True = #True " by (rule EmptySChop) 
 have 3: "\<turnstile>  empty \<frown> #True " using "1" "2" by auto
 from 3 show ?thesis by (simp add: df_d_def)
qed

(* T33 *)
lemma BfImpDf:
 "\<turnstile> bf f \<longrightarrow> df f"
proof -
 have 1: "\<turnstile> f \<longrightarrow> (empty \<longrightarrow> f)" by auto
 have 2: "\<turnstile> bf f \<longrightarrow> bf(empty \<longrightarrow> f)" by (simp add: "1" BfImpBfRule)
 have 3: "\<turnstile> bf(empty \<longrightarrow> f) \<longrightarrow> df empty \<longrightarrow> df f" by (simp add: BfImpDfImpDf)
 have 4: "\<turnstile> bf f \<longrightarrow> df empty \<longrightarrow> df f" using "2" "3" lift_imp_trans by blast
 have 5: "\<turnstile> df empty" by (simp add: DfEmpty)
 from 4 5 show ?thesis by fastforce
qed


subsection \<open>Properties of SDa and SBa\<close>

lemma SDaEqvDtDf:
 "\<turnstile>    sda  f = \<diamond> (df  f) "
proof -
 have  1: "\<turnstile> #True\<frown> (f\<frown> #True) = #True\<frown> (f\<frown> #True) " by auto
 hence 2: "\<turnstile> #True\<frown> (f\<frown> #True) = #True\<frown>  df  f " by (simp add: df_d_def)
 have  3: "\<turnstile> #True\<frown>  (df  f) = \<diamond>( df  f)" by (simp add: TrueSChopEqvDiamond)
 have  4: "\<turnstile> #True\<frown> (f\<frown> #True) = \<diamond>( df  f) " using "2" "3" by fastforce
 from 4 show ?thesis by (simp add:sda_d_def)
qed

lemma SDaEqvDfDt:
 "\<turnstile>    sda  f =  df (\<diamond> f) "
proof -
 have  1: "\<turnstile> #True\<frown> f = \<diamond> f " by (rule TrueSChopEqvDiamond)
 hence 2: "\<turnstile> (#True\<frown> f)\<frown> #True = (\<diamond> f)\<frown> #True " by (rule LeftSChopEqvSChop)
 hence 3: "\<turnstile> (#True\<frown> f)\<frown> #True =  df( \<diamond> f) " by (simp add: df_d_def)
 have  4: "\<turnstile> #True\<frown> (f\<frown> #True) = (#True\<frown> f)\<frown> #True   " by (rule SChopAssoc)
 have  5: "\<turnstile> #True\<frown> (f\<frown> #True) =  df (\<diamond> f) " using "3" "4" by fastforce
 from 5 show ?thesis by (simp add: sda_d_def)
qed

lemma DtDfEqvDfDt:
 "\<turnstile>   \<diamond> (df  f) =  df (\<diamond> f) "
by (meson Prop04 SDaEqvDfDt SDaEqvDtDf)

lemma SBaEqvBfBt:
 "\<turnstile>    sba f = bf( \<box> f) "
proof -
 have  1: "\<turnstile>  sda (\<not>  f) =  df( \<diamond> (\<not>  f)) " by (rule SDaEqvDfDt)
 have  2: "\<turnstile> \<diamond> (\<not>  f) = (\<not>( \<box> f)) " by (rule DiamondNotEqvNotBox)
 hence 3: "\<turnstile>  df (\<diamond>(\<not>  f)) =  df (\<not> (\<box> f)) " by (rule DfEqvDf)
 have  4: "\<turnstile>  sda (\<not>  f) =  df (\<not>( \<box> f)) " using "1" "3" by fastforce
 hence 5: "\<turnstile> (\<not>  (sda (\<not>  f))) = (\<not> ( df (\<not>( \<box> f)))) " by auto
 hence 6: "\<turnstile> (\<not> ( sda (\<not>  f))) = bf( \<box> f) " by (simp add: bf_d_def)
 from 6 show ?thesis by (simp add: sba_d_def)
qed
 
(* T44 *)
lemma DfNotEqvNotBf:
 "\<turnstile>    df (\<not>  f) = (\<not>( bf  f)) "
proof -
 have 1: "\<turnstile> bf  f = (\<not> ( df (\<not>  f))) " by (simp add: bf_d_def)
 from 1 show ?thesis by auto
qed

(* T45 *)
lemma DfDfNotEqvNotBfBf:
 "\<turnstile> df (df (\<not> f)) = (\<not> (bf (bf f)))"
proof -
 have 1: "\<turnstile> df (\<not> f) = (\<not> bf f)" by (simp add: DfNotEqvNotBf) 
 have 2: "\<turnstile> df ( df (\<not> f)) = df (\<not> bf f)" by (simp add: "1" DfEqvDf) 
 have 3: "\<turnstile> df (\<not> bf f) = (\<not> bf (bf f))" by (simp add: DfNotEqvNotBf)
 from 2 3 show ?thesis by fastforce
qed

(* T52 *)
lemma DfDtEqvDtDf:
 "\<turnstile> df(\<diamond> f) = \<diamond>(df f)"
proof -
 have 1: "\<turnstile> (#True\<frown>f)\<frown>#True = #True\<frown>(f\<frown>#True)"
 using SChopAssoc by fastforce
 have 2: "\<turnstile> (\<diamond> f)\<frown>#True = \<diamond>(f\<frown>#True)"
  using "1" by (metis TrueSChopEqvDiamond int_eq)
 from 1 2 show ?thesis by (simp add: df_d_def)
qed

(* T53 *)
lemma DfDtNotEqvNotBfBt:
 "\<turnstile> df(\<diamond>(\<not> f)) = (\<not>(bf(\<box> f)))"
proof -
 have 1: "\<turnstile> \<diamond> (\<not>f) = (\<not> (\<box> f))" by (simp add: DiamondNotEqvNotBox)
 have 2: "\<turnstile> df(\<diamond> (\<not>f)) = df(\<not> (\<box> f))" by (simp add: "1" DfEqvDf)
 have 3: "\<turnstile> df(\<not>(\<box> f)) = (\<not>(bf (\<box> f)))" by (simp add: DfNotEqvNotBf)
 from 2 3 show ?thesis by fastforce
qed

(* T54 *)
lemma DtDfNotEqvNotBtBf:
 "\<turnstile> \<diamond>(df (\<not> f)) = (\<not> (\<box>(bf f)))"
proof -
 have 1: "\<turnstile> df(\<not> f) = (\<not> (bf f))" using DfNotEqvNotBf by blast
 have 2: "\<turnstile> \<diamond>(df(\<not> f)) = \<diamond>(\<not> (bf f))" by (simp add: "1" DiamondEqvDiamond)
 have 3: "\<turnstile> \<diamond>(\<not> (bf f)) = (\<not> \<box>(bf f))" by (simp add: DiamondNotEqvNotBox)
 from 2 3 show ?thesis by fastforce
qed

lemma SBaEqvBtBf:
 "\<turnstile>    sba  f = \<box> (bf  f) "
proof -
 have  1: "\<turnstile>  sda (\<not>  f) = \<diamond> (df (\<not>  f)) " by (rule SDaEqvDtDf)
 have  2: "\<turnstile>  df (\<not>  f) = (\<not> (bf  f)) " by (rule DfNotEqvNotBf)
 hence 3: "\<turnstile> \<diamond> (df (\<not>  f)) = \<diamond>(\<not> (bf  f)) " by (rule DiamondEqvDiamond)
 have  4: "\<turnstile> (\<not> (\<diamond>(\<not> (bf  f)))) = \<box>(bf  f)  " by (rule NotDiamondNotEqvBox)
 have  5: "\<turnstile> (\<not> ( sda (\<not>  f))) = \<box>(bf  f) " using "1" "2" "3" "4" by fastforce
 from 5 show ?thesis by (simp add: sba_d_def)
qed

lemma BaImpSBa:
 "\<turnstile> ba f \<longrightarrow> sba f"
using BaEqvBiBt BiImpBf SBaEqvBfBt by fastforce

lemma SDaImpDa:
 "\<turnstile> sda f \<longrightarrow> da f"
proof -
 have 1: "\<turnstile> ba (\<not> f) \<longrightarrow> sba (\<not>f) " 
   using BaImpSBa by blast
 have 2: "\<turnstile> \<not> sba (\<not>f) \<longrightarrow> \<not> ba (\<not> f)"
   using 1 by fastforce
 from 2 show ?thesis by (simp add: sba_d_def ba_d_def)
qed

(* T55 *)
lemma BtBfEqvBfBt:
 "\<turnstile>   \<box> (bf  f) = bf( \<box> f) "
proof -
 have 1: "\<turnstile>    sba  f = \<box> (bf  f)  " by (rule SBaEqvBtBf)
 have 2: "\<turnstile>    sba  f = bf( \<box> f) "  by (rule SBaEqvBfBt)
 from 1 2 show ?thesis by fastforce
qed

lemma BoxStateEqvSBaBoxState:
 "\<turnstile>   \<box> (init w) =  sba (\<box> (init w)) "
proof -
 have  1: "\<turnstile> (init w) = bf  (init w) " by (rule StateEqvBf)
 hence 2: "\<turnstile> \<box> (init w) = \<box> (bf  (init w)) " by (rule BoxEqvBox)
 have  3: "\<turnstile> \<box> (bf  (init w)) = bf( \<box> (init w))  " by (rule BtBfEqvBfBt)
 have  4: "\<turnstile> \<box> (init w) = \<box>(\<box> (init w)) " by (rule BoxEqvBoxBox)
 hence 5: "\<turnstile> bf( \<box> (init w)) = bf (\<box>(\<box> (init w))) " by (rule BfEqvBf)
 have  6: " \<turnstile>  sba( \<box> (init w)) = bf( \<box>(\<box> (init w))) "  by (rule SBaEqvBfBt)
 from 2 3 5 6 show ?thesis  by fastforce 
qed

lemma SBaImpBf:
 "\<turnstile>    sba  f \<longrightarrow> bf  f "
proof -
 have 1: "\<turnstile>  sba  f = \<box>(bf  f) " by (rule SBaEqvBtBf)
 have 2: "\<turnstile> \<box>(bf  f) \<longrightarrow> bf  f " by (rule BoxElim)
 from 1 2 show ?thesis using lift_imp_trans by fastforce
qed

lemma BaImpBf:
 "\<turnstile>    ba  f \<longrightarrow> bf  f "
proof -
 have 1: "\<turnstile>  ba  f = \<box>(bi  f) " by (rule BaEqvBtBi)
 have 2: "\<turnstile> \<box>(bi  f) \<longrightarrow> bi  f " by (rule BoxElim)
 have 3: "\<turnstile> bi  f \<longrightarrow> bf f" by (simp add: BiImpBf)
 from 1 2 3 show ?thesis using lift_imp_trans by fastforce
qed

lemma SBaImpBt:
 "\<turnstile>    sba  f \<and> finite \<longrightarrow> \<box> f "
proof -
 have 1: "\<turnstile>  sba  f = bf( \<box> f) " by (rule SBaEqvBfBt)
 have 2: "\<turnstile> bf( \<box> f) \<and> finite \<longrightarrow> \<box> f " by (rule BfElim)
 from 1 2 show ?thesis by fastforce
qed

lemma DiamondImpSDa:
 "\<turnstile>   \<diamond> f \<and> finite \<longrightarrow>  sda  f "
by (metis AndFiniteImpDf SDaEqvDfDt inteq_reflection)

lemma DfImpSDa:
 "\<turnstile>    df  f \<longrightarrow>  sda  f"
using NowImpDiamond SDaEqvDtDf by fastforce

lemma BoxAndSChopImport:
 "\<turnstile>   \<box> h \<and> f\<frown> g \<longrightarrow> f\<frown> (h \<and> g) " 
proof -
 have  1: "\<turnstile> h \<longrightarrow> g \<longrightarrow> (h \<and> g) " by auto
 hence 2: "\<turnstile> \<box> h \<longrightarrow> \<box>(g \<longrightarrow> (h \<and> g)) " by (rule ImpBoxRule)
 have  3: "\<turnstile> \<box>(g \<longrightarrow> (h \<and> g)) \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> (h\<and> g) " by (rule BoxSChopImpSChop)
 from 2 3 show ?thesis by fastforce
qed

lemma SBaAndSChopImport:
 " \<turnstile>    sba f \<and> finite \<and> (g\<frown> g1)  \<longrightarrow> (f \<and> g)\<frown> (f \<and> g1) "
proof -
 have  1: "\<turnstile> sba  f \<longrightarrow> bf  f " by (rule SBaImpBf)
 have  2: "\<turnstile> bf  f \<and> (g\<frown> g1) \<longrightarrow> (f \<and> g)\<frown> g1 " by (rule BfAndSChopImport)
 have  3: "\<turnstile> sba  f \<and> finite \<longrightarrow> \<box> f " by (rule SBaImpBt)
 have  4: "\<turnstile> \<box> f \<and> (f \<and> g)\<frown> g1 \<longrightarrow> (f \<and> g)\<frown> (f \<and> g1) " by (rule BoxAndSChopImport)
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma BaAndSChopImport:
 " \<turnstile>    ba f \<and> (g\<frown> g1)  \<longrightarrow> (f \<and> g)\<frown> (f \<and> g1) "
proof -
 have  1: "\<turnstile> ba  f \<longrightarrow> bi  f " by (rule BaImpBi)
 have  2: "\<turnstile> bi  f \<and> (g\<frown> g1) \<longrightarrow> (f \<and> g)\<frown> g1 " by (rule BiAndSChopImport)
 have  3: "\<turnstile> ba  f  \<longrightarrow> \<box> f " by (rule BaImpBt)
 have  4: "\<turnstile> \<box> f \<and> (f \<and> g)\<frown> g1 \<longrightarrow> (f \<and> g)\<frown> (f \<and> g1) " by (rule BoxAndSChopImport)
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma SChopAndCommute:
 "\<turnstile>   f\<frown> (g \<and> g1) = f\<frown> (g1 \<and> g) "
proof -
 have 1: "\<turnstile> (g \<and> g1) = (g1 \<and> g)" by auto
 from 1 show ?thesis by (rule RightSChopEqvSChop)
qed

lemma SChopAndA: 
 "\<turnstile>   f\<frown> (g \<and> g1) \<longrightarrow> f\<frown> g "
proof -
 have 1: "\<turnstile> (g \<and> g1) \<longrightarrow>  g " by auto
 from 1 show ?thesis by (rule RightSChopImpSChop)
qed

lemma SChopAndB:
 "\<turnstile>   f\<frown> (g \<and> g1) \<longrightarrow> f\<frown> g1 "
proof -
 have 1: "\<turnstile> (g \<and> g1) \<longrightarrow>  g1 " by auto
from 1 show ?thesis by (rule RightSChopImpSChop)
qed
 
lemma BoxStateAndSChopEqvSChop:
 "\<turnstile>   (\<box> (init w) \<and> finite \<and> (f\<frown> g)) = ((\<box> (init w) \<and> f)\<frown> (\<box> (init w) \<and> g) \<and> finite) "
proof -
 have  1: "\<turnstile> \<box> (init w) =  sba( \<box> (init w)) " 
   by (rule BoxStateEqvSBaBoxState)
 have  2: "\<turnstile> sba( \<box> (init w)) \<and> finite \<and> (f\<frown> g) \<longrightarrow> (\<box> (init w) \<and> f)\<frown> (\<box> (init w) \<and> g) " 
   by (rule SBaAndSChopImport)
 have  3: "\<turnstile> \<box> (init w) \<and> finite \<and> (f\<frown> g) \<longrightarrow> (\<box> (init w) \<and> f)\<frown> (\<box> (init w) \<and> g) " 
   using "1" "2"  by fastforce 
 have 11: "\<turnstile> (\<box> (init w) \<and> f)\<frown> (\<box> (init w) \<and> g) \<longrightarrow> (\<box> (init w))\<frown> (\<box> (init w) \<and> g) " 
   by (rule AndSChopA)
 have 12: "\<turnstile> (\<box> (init w))\<frown> (\<box> (init w) \<and> g) \<longrightarrow> (\<box> (init w))\<frown> (\<box> (init w)) " 
   by (rule SChopAndA)
 have 13: "\<turnstile> (\<box> (init w))\<frown> (\<box> (init w)) = \<box> (init w) " 
   by (rule BoxStateSChopBoxEqvBox)
 have 14: "\<turnstile> (\<box> (init w) \<and> f)\<frown> (\<box> (init w) \<and> g) \<longrightarrow> f\<frown> (\<box> (init w) \<and> g) " 
   by (rule AndSChopB)
 have 15: "\<turnstile> f\<frown> (\<box> (init w) \<and> g) \<longrightarrow> f\<frown> g " 
   by (rule SChopAndB)
 have 16: "\<turnstile> (\<box> (init w) \<and> f)\<frown> (\<box> (init w) \<and> g) \<longrightarrow> \<box> (init w) \<and> (f\<frown> g) " 
   using  "11" "12" "13" "14" "15"  by fastforce
 from 3 16 show ?thesis by fastforce
qed

(* T22 *)
lemma DfEqvNotBfNot:
 " \<turnstile>    df  f = (\<not>( bf (\<not>  f))) "
proof -
 have  1: "\<turnstile> bf (\<not>  f) = (\<not> ( df (\<not> \<not>  f))) " by (simp add: bf_d_def)
 hence 2: "\<turnstile>  df (\<not> \<not>  f) = (\<not>( bf (\<not>  f))) " by auto
 have  3: "\<turnstile> f = (\<not> \<not>  f) " by auto
 hence 4: "\<turnstile>  df  f =  df  (\<not> \<not>  f) " by (rule DfEqvDf)
 from 2 4 show ?thesis by auto
qed

lemma SChopAndBoxImport:
 "\<turnstile>   f\<frown> g \<and> \<box> h \<longrightarrow> f\<frown> (g \<and> h) "
proof -
 have 1: "\<turnstile> \<box> h \<and> f\<frown> g \<longrightarrow> f\<frown> (h \<and> g) " by (rule BoxAndSChopImport)
 have 2: "\<turnstile> f\<frown> (h \<and> g) = f\<frown> (g \<and> h) " by (rule SChopAndCommute)
 from 1 2 show ?thesis by fastforce
qed

lemma AndSChopAndCommute:
 "\<turnstile>   (f \<and> g)\<frown> (f1 \<and> g1) = (g \<and> f)\<frown> (g1 \<and> f1) "
proof -
 have 1: "\<turnstile> (f \<and> g)\<frown> (f1 \<and> g1) = (g \<and> f)\<frown> (f1 \<and> g1) " by (rule AndSChopCommute)
 have 2: "\<turnstile> (g \<and> f)\<frown> (f1 \<and> g1) = (g \<and> f)\<frown> (g1 \<and> f1) "  by (rule SChopAndCommute)
 from 1 2 show ?thesis by fastforce
qed

lemma SChopImpSChop:
 assumes "\<turnstile> f \<longrightarrow> f1 " 
         "\<turnstile> g \<longrightarrow> g1 "
 shows   "\<turnstile> f\<frown>g \<longrightarrow> f1\<frown>g1 "
proof -
 have  1: "\<turnstile> f \<longrightarrow> f1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> f1\<frown> g " by (rule LeftSChopImpSChop)
 have  3: "\<turnstile> g \<longrightarrow> g1 " using assms by auto
 hence 4: "\<turnstile> f1\<frown> g \<longrightarrow> f1\<frown> g1 " by (rule RightSChopImpSChop)
 from 2 4 show ?thesis by fastforce
qed

lemma SChopEqvSChop:
 assumes "\<turnstile> f = f1" 
         "\<turnstile> g = g1 "
 shows   "\<turnstile> f\<frown>g = f1\<frown>g1 "
proof -
 have  1: "\<turnstile> f = f1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> g = f1\<frown> g " by (rule LeftSChopEqvSChop)
 have  3: "\<turnstile> g = g1 " using assms by auto
 hence 4: "\<turnstile> f1\<frown> g = f1\<frown> g1 " by (rule RightSChopEqvSChop)
 from 2 4 show ?thesis by fastforce
qed

lemma BoxSChopImpSChopBox:
 "\<turnstile>   \<box> h \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> (\<box> h \<and> g) "
proof -
 have 1: "\<turnstile> \<box> h \<longrightarrow> \<box>(g \<longrightarrow> \<box> h \<and> g ) " by (rule BoxImpBoxImpBox)
 have 2: "\<turnstile> \<box>(g \<longrightarrow> \<box> h \<and> g ) \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> (\<box> h \<and> g) " by (rule BoxSChopImpSChop)
 from 1 2 show ?thesis by fastforce
qed

lemma NotChopEqvSYieldsNot:
"\<turnstile>   (\<not> (f\<frown> g)) = f syields  (\<not>  g) "
proof -
 have  1: "\<turnstile> g = (\<not> \<not>  g) " by auto
 hence 2: "\<turnstile> f\<frown> g = f\<frown> (\<not> \<not>  g) " by (rule RightSChopEqvSChop)
 hence 3: "\<turnstile> (\<not> (f\<frown> g)) = (\<not> (f\<frown> (\<not> \<not>  g))) " by auto
 from 3 show ?thesis by (simp add: syields_d_def)
qed

lemma NotDfFalse:
 "\<turnstile>   \<not> ( df  #False) "
proof -
 have  1: "\<turnstile> (init #True) \<longrightarrow> bf (init #True) " by (rule StateImpBf)
 hence 2: "\<turnstile> #True \<longrightarrow> bf #True " by (simp add: BfGen)
 have  3: "\<turnstile> #True" by auto
 have  4: "\<turnstile> bf #True" using "2" "3" MP by auto
 hence 5: "\<turnstile> \<not> ( df (\<not> #True)) " by (simp add: bf_d_def)
 have  6: "\<turnstile> (\<not> #True) =  #False " by auto
 hence 7: "\<turnstile>  df (\<not> #True) =  df  #False " by (rule DfEqvDf)
 from 5 7 show ?thesis by auto
qed

(* T42 *)
lemma StateAndEmptySChop:
 "\<turnstile>   ((init w) \<and>  empty )\<frown> f = ((init w) \<and> f) "
proof - 
 have 1: "\<turnstile> ((init w) \<and>  empty )\<frown> f = ((init w) \<and>  empty \<frown> f) " by (rule StateAndSChop)
 have 2: "\<turnstile>  empty \<frown> f = f " by (rule EmptySChop)
 from 1 2 show ?thesis by fastforce
qed

(* T49 *)
lemma StateAndNextSChop:
 "\<turnstile>   ((init w) \<and> \<circle> f)\<frown> g = ((init w) \<and> \<circle>(f\<frown> g)) "
proof -
 have 1: "\<turnstile> ((init w) \<and> \<circle> f)\<frown> g = ((init w) \<and> (\<circle> f)\<frown> g) " by (rule StateAndSChop)
 have 2: "\<turnstile> (\<circle> f)\<frown> g = \<circle>(f\<frown> g) " by (rule NextSChop)
 from 1 2 show ?thesis by fastforce
qed

lemma NextStateAndSChop:
 "\<turnstile>   \<circle>(((init w) \<and> f)\<frown> g) = (\<circle> (init w) \<and> \<circle>(f\<frown> g)) "
proof -
 have  1: "\<turnstile> ((init w) \<and> f)\<frown> g = ((init w) \<and> f\<frown> g)  " by (rule StateAndSChop)
 hence 2: "\<turnstile> \<circle>(((init w) \<and> f)\<frown> g) = \<circle>((init w) \<and> f\<frown> g) " by (rule NextEqvNext)
 have  3: "\<turnstile> \<circle>((init w) \<and> f\<frown> g) = (\<circle> (init w) \<and> \<circle>(f\<frown> g)) " by (rule NextAndEqvNextAndNext)
 from 2 3 show ?thesis by fastforce
qed

lemma StateSYieldsEqv:
 "\<turnstile>    ((init w) \<longrightarrow> (f syields  g)) = ((init w) \<and> f) syields  g " 
proof -
 have  1: "\<turnstile> ((init w) \<and> f)\<frown> (\<not>  g) = ((init w) \<and> f\<frown> (\<not>  g))  " by (rule StateAndSChop)
 hence 2: "\<turnstile> ((init w) \<longrightarrow> \<not> (f\<frown> (\<not>  g))) = (\<not> (((init w) \<and> f)\<frown> (\<not>  g) )) " by auto
 from 2 show ?thesis by (simp add: syields_d_def)
qed

lemma StateAndDf:
 "\<turnstile>   ((init w) \<and>  df  f) =  df ((init w) \<and> f) "
proof - 
 have 1: "\<turnstile> ((init w) \<and> f)\<frown> #True=  ((init w) \<and> f\<frown> #True)  " by (rule StateAndSChop)
 from 1 show ?thesis by (metis df_d_def inteq_reflection)
qed

lemma DfNext: 
 "\<turnstile>    df( \<circle> f) = \<circle> (df  f) "
proof -
 have 1: "\<turnstile> (\<circle> f)\<frown> #True = \<circle>(f\<frown> #True) " by (rule NextSChop)
 from 1 show ?thesis by (simp add: df_d_def)
qed

lemma DfNextState:
 "\<turnstile>    df( \<circle> (init w)) = \<circle> (init w) "
proof -
 have  1: "\<turnstile>  df( \<circle> (init w)) = \<circle>( df  (init w)) " by (rule DfNext)
 have  2: "\<turnstile>  df  (init w) = (init w) " by (rule DfState)
 hence 3: "\<turnstile> \<circle>( df  (init w)) = \<circle> (init w) " by (rule NextEqvNext)
 from 1 3 show ?thesis by fastforce
qed

(* T50 *)
lemma DfStateAndNextStateEqvStateAndNextState:
 "\<turnstile> df(init w \<and> \<circle>(init w1)) = (init w \<and> \<circle>(init w1))"
proof -
 have 1: "\<turnstile> (init w \<and> \<circle>(init w1))\<frown>#True = ( init w \<and> \<circle>((init w1)\<frown> #True))"
   using StateAndNextSChop by blast 
 have 2: "\<turnstile> df(init w \<and> \<circle>(init w1)) = ( init w \<and> \<circle>((init w1)\<frown> #True))"
   using "1" by (simp add: df_d_def)
 have 3: "\<turnstile> df(init w1) = init w1" 
   by (simp add: DfState)
 have 4: "\<turnstile> skip\<frown>df(init w1) = skip\<frown>(init w1)" 
   by (simp add: "3" RightSChopEqvSChop)
 have 5: "\<turnstile> \<circle>(df(init w1)) = \<circle>(init w1)"
   by (simp add: "3" NextEqvNext)
 from 2 5 show ?thesis by (metis df_d_def int_eq)
qed

lemma StateImpBfGen:
 assumes "\<turnstile> (init w) \<longrightarrow> f "
 shows   "\<turnstile> (init w) \<longrightarrow> bf  f "
proof -
 have  1: "\<turnstile> (init w) \<longrightarrow> f " using assms by auto
 hence 2: "\<turnstile> \<not>  f \<longrightarrow> \<not>  (init w) " by auto
 hence 3: "\<turnstile>  df (\<not>  f) \<longrightarrow>  df (\<not>  (init w)) " by (rule DfImpDf)
 hence 4: "\<turnstile>  df (\<not>  f) \<longrightarrow>  df  (init (\<not>w)) " by (metis Initprop(2) inteq_reflection)
 have  5: "\<turnstile>  df (init (\<not> w)) =   (init (\<not> w)) " by (rule DfState)
 have  6: "\<turnstile>  df (\<not>  f) \<longrightarrow> \<not>  (init w) " using 4 5 using Initprop(2) by fastforce
 hence 7: "\<turnstile> (init w) \<longrightarrow> \<not> ( df (\<not>  f)) " by auto
 from 7 show ?thesis by (simp add: bf_d_def)
qed

lemma SChopAndNotSChopImp:
 "\<turnstile>   f\<frown> g \<and> \<not> (f\<frown> g1) \<longrightarrow> f\<frown> (g \<and> \<not>  g1) "
proof -
 have  1: "\<turnstile> g \<longrightarrow> (g \<and> \<not>  g1) \<or>  g1 " by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> f\<frown> ((g\<and> \<not>  g1) \<or>  g1) " by (rule RightSChopImpSChop)
 have  3: "\<turnstile> f\<frown> ((g\<and> \<not>  g1) \<or>  g1) \<longrightarrow> (f\<frown> (g\<and> \<not>  g1)) \<or>  (f\<frown> g1) " by (rule SChopOrImp)
 have  4: "\<turnstile> f\<frown> g \<longrightarrow> f\<frown> (g\<and> \<not>  g1) \<or>  f\<frown> g1 " using "2" "3" MP by fastforce
 from 4 show ?thesis by auto
qed

lemma SChopAndSYieldsImp:
 "\<turnstile>   f\<frown> g \<and> f syields  g1 \<longrightarrow> f\<frown> (g \<and> g1) "
proof -
 have  1: "\<turnstile> g \<longrightarrow> (g \<and> g1) \<or>  \<not>  g1 " by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> f\<frown> ((g\<and>   g1) \<or>  \<not> g1) "  by (rule RightSChopImpSChop)
 have  3: "\<turnstile> f\<frown> ((g \<and>   g1) \<or>  \<not> g1) \<longrightarrow> (f\<frown> (g\<and>   g1)) \<or>  (f\<frown> (\<not> g1)) " by (rule SChopOrImp)
 have  4: "\<turnstile> f\<frown> g \<longrightarrow> f\<frown> (g\<and>   g1) \<or>  f\<frown> (\<not> g1) " using "2" "3" MP by fastforce
 hence 5: "\<turnstile> f\<frown> g \<and> \<not>  (f\<frown> (\<not>  g1)) \<longrightarrow> f\<frown> (g \<and> g1) " by auto
 from 5 show ?thesis by (simp add: syields_d_def)
qed

lemma SChopAndSYieldsMP:
 "\<turnstile>   f\<frown> g \<and> f syields (g\<longrightarrow> g1) \<longrightarrow> f\<frown> g1 "
proof -
 have  1: "\<turnstile> f\<frown> g \<and> f syields (g\<longrightarrow> g1) \<longrightarrow> f\<frown> (g \<and> (g \<longrightarrow> g1)) " by (rule SChopAndSYieldsImp)
 have  2: "\<turnstile> g \<and> (g \<longrightarrow> g1) \<longrightarrow> g1 " by auto
 hence 3: "\<turnstile> f\<frown> (g \<and> (g \<longrightarrow> g1)) \<longrightarrow> f\<frown> g1 " by (rule RightSChopImpSChop)
 from 1 3 show ?thesis by fastforce
qed

lemma OrSYieldsImp:
  "\<turnstile>   (f \<or>  f1) syields  g = ((f syields  g) \<and> (f1 syields  g)) "
proof -
 have  1: "\<turnstile> ((f\<or>  f1)\<frown> (\<not>  g)) = ((f\<frown> (\<not>  g)) \<or>  (f1\<frown> (\<not>  g))) " by (rule OrSChopEqv)
 hence 2: "\<turnstile> (\<not> ((f\<or>  f1)\<frown> (\<not>  g))) = (\<not> (f\<frown> (\<not>  g)) \<and>  \<not>(f1\<frown> (\<not>  g))) " by auto
 from 2 show ?thesis by (simp add: syields_d_def)
qed

lemma LeftSYieldsImpSYields:
 assumes "\<turnstile> f \<longrightarrow> f1 "
 shows   "\<turnstile> (f1 syields  g) \<longrightarrow> (f syields  g) "
proof -
 have  1: "\<turnstile> f \<longrightarrow> f1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> (\<not>  g) \<longrightarrow> f1\<frown> (\<not>  g)  " by (rule LeftSChopImpSChop)
 hence 3: "\<turnstile> \<not> (f1\<frown> (\<not>  g)) \<longrightarrow> \<not> (f\<frown> (\<not>  g)) " by auto
 from 3 show ?thesis by (simp add: syields_d_def)
qed

lemma LeftSYieldsEqvSYields:
 assumes "\<turnstile>  f = f1 "
 shows "\<turnstile> (f syields  g) = (f1 syields  g) "
proof -
 have  1: "\<turnstile> f = f1 " using assms by auto
 hence 2: "\<turnstile> f\<frown> (\<not>  g) = f1\<frown> (\<not>  g) " by (rule LeftSChopEqvSChop)
 hence 3: "\<turnstile> (\<not> (f\<frown> (\<not>  g))) = (\<not> (f1\<frown> (\<not>  g))) " by auto
 from 3 show ?thesis by (simp add: syields_d_def)
qed


subsection \<open>Properties of SFin\<close>

lemma SFinEqvTrueSChopAndEmpty:
 " \<turnstile>  sfin f = #True\<frown>(f \<and> empty)"
proof -
 have 01: "\<turnstile> sfin f = (\<not> fin (\<not> f))"
   by (simp add: sfin_d_def)
 have 02:"\<turnstile> (\<not> fin (\<not> f)) = (\<not> ( \<box> (empty \<longrightarrow> \<not> f)))"
   by (simp add: fin_d_def)
 have 03:"\<turnstile> (\<not> ( \<box> (empty \<longrightarrow> \<not> f))) = \<diamond>(\<not>(empty \<longrightarrow> \<not> f)) "
   by (simp add: always_d_def)
 have 04: "\<turnstile> \<not>(empty \<longrightarrow> \<not> f) = (empty \<and> f)"
   by auto
 have 05:"\<turnstile> \<diamond>(\<not>(empty \<longrightarrow> \<not> f)) = \<diamond> (empty \<and> f)"
   using "04" inteq_reflection by fastforce
 from 01 02 03 05 show ?thesis 
   by (metis SChopAndCommute TrueSChopEqvDiamond inteq_reflection)
qed

lemma DiamondSFin:
 "\<turnstile> \<diamond>(sfin w) = sfin w"
by (metis (no_types, lifting) ChopAssoc FiniteChopFiniteEqvFinite FiniteOr FiniteOrInfinite 
   InfEqvNotFinite OrFiniteInf SFinEqvTrueSChopAndEmpty finite_d_def int_eq_true 
   int_simps(21) inteq_reflection schop_d_def sometimes_d_def)

lemma SChopSFinExportA:
 "\<turnstile> f\<frown>(g \<and> sfin w) \<longrightarrow> sfin w"
using DiamondSFin 
by (metis SChopAndB SChopImpDiamond inteq_reflection lift_imp_trans)

lemma SFinImpBox:
 "\<turnstile> sfin w \<longrightarrow> \<box>(sfin w)" 
by (metis (mono_tags, lifting) DiamondFin always_d_def intI int_eq int_simps(4) sfin_d_def unl_lift2)

lemma SFinAndSChopImport:
 "\<turnstile> (sfin w) \<and> (f\<frown>g) \<longrightarrow> f\<frown>((sfin w) \<and> g)"
proof -
 have 1: "\<turnstile> sfin w \<longrightarrow> \<box>(sfin w)" by (rule SFinImpBox)
 hence 2: "\<turnstile> sfin w \<and> (f\<frown>g) \<longrightarrow> \<box>(sfin w) \<and> (f\<frown>g)" by auto
 have 3: "\<turnstile> \<box>(sfin w) \<and> (f\<frown>g)  \<longrightarrow> f\<frown>((sfin w) \<and> g)" using BoxAndSChopImport by blast
 from 2 3 show ?thesis using MP by fastforce
qed

lemma SFinAndSChop:
 "\<turnstile> (f\<frown>(g \<and> sfin w)) = (sfin w \<and> f\<frown>g)  "
using SFinAndSChopImport SChopSFinExportA SChopAndA SChopAndCommute 
by fastforce

lemma SChopAndEmptyEqvEmptySChopEmpty:
 "\<turnstile> ((f\<frown>g) \<and> empty) = (f \<and> empty)\<frown>(g \<and> empty) "
by (auto simp: itl_defs  zero_enat_def ) 

lemma SFinAndEmpty:
 "\<turnstile> ((sfin w) \<and> empty) = (w \<and> empty)"
proof -
 have 1: "\<turnstile> ((sfin w) \<and> empty) = (#True\<frown>(w \<and> empty) \<and> empty)" 
   using SFinEqvTrueSChopAndEmpty by fastforce
 have 2: "\<turnstile> (#True\<frown>(w \<and> empty) \<and> empty) = ((#True \<and> empty)\<frown>(w \<and> empty))"
   by (simp add: FiniteChopAndEmptyEqvChopAndEmpty schop_d_def) 
 have 3: "\<turnstile> (#True \<and> empty)\<frown>(w \<and> empty) = (empty\<frown>(w \<and> empty))" 
   using LeftSChopEqvSChop by fastforce
 have 4: "\<turnstile> (empty\<frown>(w \<and> empty)) = (w \<and> empty)" 
   using EmptySChop by blast
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma AndSFinEqvSChopAndEmpty:
 "\<turnstile>   ((f \<and> finite) \<and> sfin g) = f\<frown> (g \<and>  empty ) "
proof -
 have 1: "\<turnstile> ((f \<and> finite) \<and> sfin g) = (f\<frown>empty \<and> sfin g)" 
   using SChopEmpty
   by (metis (no_types, lifting) DiamondEmptyEqvFinite FiniteImpAnd Prop10 SChopImpDiamond 
       inteq_reflection lift_and_com)
 have 2: "\<turnstile> (sfin g \<and> f\<frown>empty) = (f\<frown>(empty \<and> sfin g))  " 
   using SFinAndSChop by fastforce
 have 3: "\<turnstile> (empty \<and> sfin g) =  (sfin g \<and> empty)" 
   by auto
 have 4: "\<turnstile> (sfin g \<and> empty) = (g \<and> empty)" 
   using SFinAndEmpty by metis
 have 5: "\<turnstile> (empty \<and> sfin g) = (g \<and> empty)" 
   using "3" "4" by auto
 hence 6: "\<turnstile> f\<frown>(empty \<and> sfin g) = f\<frown>(g \<and> empty)" 
   using RightSChopEqvSChop by blast
 from 1 2 5 show ?thesis by (metis inteq_reflection lift_and_com)
qed

lemma AndSFinEqvSChopStateAndEmpty:
 "\<turnstile>   ((f \<and> finite) \<and>  sfin  (init w)) = f \<frown> ((init w) \<and>  empty ) "
using AndSFinEqvSChopAndEmpty by blast

lemma DiamondEqvEmptyOrNextDiamond:
 "\<turnstile> \<diamond> f = (f  \<or> \<circle>(\<diamond> f))"
proof -
 have 1: "\<turnstile> \<box> (\<not> f) = ((\<not> f) \<and> wnext(\<box> (\<not> f)))"
   by (simp add: BoxEqvAndWnextBox)
 have 2: "\<turnstile> (\<not> \<diamond> f) = ((\<not>f) \<and> wnext(\<box> (\<not> f)))"
   using "1" by (simp add: always_d_def)
 have 3: "\<turnstile>  \<diamond> f = (f \<or> \<not>(wnext(\<box> (\<not> f))))"
   using "2" by auto
 have 4: "\<turnstile> (\<not>(wnext(\<box> (\<not> f)))) = \<circle>(\<not>\<box>(\<not>f))"
   by (simp add: wnext_d_def) 
 have 5: "\<turnstile> \<not>\<box>(\<not>f) = \<diamond> f"
   by (simp add: always_d_def)
 have 6: "\<turnstile> \<circle>(\<not>\<box>(\<not>f)) = \<circle>(\<diamond> f)"
   using "5" using inteq_reflection by force
 from 3 4 6 show ?thesis by fastforce
qed

lemma SFinStateEqvStateAndEmptyOrNextSFinState:
 "\<turnstile>  sfin  (init w) = (((init w) \<and> empty)  \<or>  \<circle>( sfin  (init w))) "
proof -
 have 01: "\<turnstile> sfin (init w) = #True\<frown>((init w) \<and> empty)"
   by (simp add: SFinEqvTrueSChopAndEmpty) 
 have 02: "\<turnstile> #True\<frown>((init w) \<and> empty) = \<diamond> ((init w) \<and> empty)"
   by (simp add: TrueSChopEqvDiamond)
 have 03: "\<turnstile> \<diamond> ((init w) \<and> empty) = (((init w) \<and> empty)  \<or>  \<circle>( sfin  (init w)))"
   using DiamondEqvEmptyOrNextDiamond "02" "01" by (metis inteq_reflection)
 from 01 02 03 show ?thesis by fastforce
qed

lemma SFinSChopEqvOr:
 " \<turnstile>   ( sfin  (init w))\<frown> f = (((init w) \<and> f) \<or>  \<circle>(( sfin  (init w))\<frown> f)) "
proof -
 have  1: "\<turnstile>  sfin  (init w) = (((init w) \<and>  empty ) \<or>  \<circle>( sfin  (init w))) " 
   by (rule SFinStateEqvStateAndEmptyOrNextSFinState)
 hence 2: "\<turnstile> ( sfin  (init w))\<frown> f = (((init w) \<and>  empty )\<or>  \<circle>( sfin  (init w)))\<frown> f" 
   by (rule LeftSChopEqvSChop)
 have  3: "\<turnstile> (((init w) \<and>  empty )\<or>  \<circle> (sfin  (init w)))\<frown> f
            = (((init w) \<and>  empty )\<frown> f \<or>  (\<circle> (sfin  (init w)))\<frown> f) " 
   by (rule OrSChopEqv)
 have  4: "\<turnstile> ((init w) \<and>  empty )\<frown> f = ((init w) \<and> f) " 
   by (rule StateAndEmptySChop)
 have  5: "\<turnstile> (\<circle> (sfin  (init w)))\<frown> f = \<circle>(( sfin  (init w))\<frown> f) " 
   by (rule NextSChop)
 from 2 3 4 5 show ?thesis by fastforce
qed

lemma SFinSChopEqvDiamond:
 "\<turnstile>   ( sfin  (init w))\<frown> f = \<diamond> ((init w) \<and> f) "
proof -
 have  1: "\<turnstile> ( sfin  (init w)) = (#True\<frown>((init w) \<and> empty))" 
   by (simp add: SFinEqvTrueSChopAndEmpty)
 hence 2: "\<turnstile> (sfin  (init w))\<frown>f = (#True\<frown>((init w) \<and> empty))\<frown>f" 
   by (rule LeftSChopEqvSChop)
 have  3: "\<turnstile> #True\<frown>(( (init w) \<and> empty)\<frown>f)  = (#True\<frown>((init w) \<and> empty))\<frown>f " 
   by (rule SChopAssoc)
 have  4: "\<turnstile> #True\<frown>(( (init w) \<and> empty)\<frown>f)= \<diamond> ( ( (init w) \<and> empty)\<frown>f) " 
   using TrueSChopEqvDiamond by blast
 have  5: "\<turnstile> ( (init w) \<and> empty)\<frown>f = ((init w) \<and> f) " 
   using StateAndEmptySChop by blast 
 hence 6: "\<turnstile> \<diamond> ( ( (init w) \<and> empty)\<frown>f) = \<diamond> ( (init w) \<and> f) " 
   by (rule DiamondEqvDiamond)
 from 2 3 4 6 show ?thesis by fastforce
qed

lemma SFinSYields:
 "\<turnstile>    ( sfin  (init w))  syields  (init w) "
proof -
 have 1: "\<turnstile> (sfin (init w))\<frown> (\<not>(init w)) = \<diamond>((init w) \<and> \<not>(init w)) " 
   by (rule SFinSChopEqvDiamond)
 have 2: "\<turnstile>  \<not>( \<diamond>((init w) \<and> \<not>  (init w))) " 
   by (rule NotDiamondAndNot)
 have 3: "\<turnstile> \<not> (( sfin  (init w))\<frown> (\<not>  (init w))) " 
   using "1" "2" by fastforce
 from 3 show ?thesis by (simp add: syields_d_def)
qed

lemma SFinEQvFinAndFinite:
 " \<turnstile> (finite \<and> fin f) = sfin f "
by (metis AndFinEqvChopAndEmpty DiamondSChopdef SFinEqvTrueSChopAndEmpty int_simps(20) 
    inteq_reflection sometimes_d_def)

lemma AndFiniteImpAndSFinStateOrSFinNotState:
 "\<turnstile> f \<and> finite \<longrightarrow> (f \<and> sfin (init w)) \<or> (f \<and> sfin (\<not> (init w))) "
proof -
 have 1: "\<turnstile> (\<not> fin (init (\<not> w)) \<and> finite) = (fin (init (\<not> \<not> w)) \<and> finite)"
   using FinNotStateEqvNotFinState by blast
 have 2: "\<turnstile> (fin (init (\<not> \<not> w)) \<and> finite) = (fin (init (w)) \<and> finite)" 
   by simp
 have 3: "\<turnstile> f \<and> finite \<longrightarrow> (f \<and> finite) \<and> fin (init w) \<or> (f \<and> finite) \<and> fin (\<not> init w)" 
   by (simp add: ImpAndFinStateOrFinNotState)
 have 4: "\<turnstile> (finite \<and> fin (init w)) = sfin(init w)"
   using SFinEQvFinAndFinite[of "LIFT(init w)"] by fastforce
 have 5: "\<turnstile> ((f \<and> finite) \<and> fin (init w)) =  (f \<and> sfin (init w))"
   using 4 by auto
 have 6: "\<turnstile> (finite \<and> fin (\<not>(init w))) = sfin(\<not>(init w))" 
   using SFinEQvFinAndFinite[of "LIFT(\<not>(init w))"] by fastforce
 have 7: "\<turnstile> ((f \<and> finite) \<and> fin (\<not> (init w))) = (f \<and> sfin (\<not> (init w)))"
   using 6 by auto
 show ?thesis 
   using "3" "5" "7" by fastforce
qed

lemma AndSFinSChopEqvStateAndSChop:
 "\<turnstile>   (f  \<and> sfin  (init w))\<frown> g = f\<frown> ((init w) \<and> g) "
proof -
 have   1: "\<turnstile> ( sfin  (init w)) syields  (init w) " 
   by (rule SFinSYields)
 have   2: "\<turnstile> f \<and>  sfin  (init w) \<longrightarrow>  sfin  (init w) " 
   by auto
 hence  3: "\<turnstile> ( sfin  (init w)) syields  (init w) \<longrightarrow> 
              (f \<and>  sfin  (init w)) syields  (init w) " 
   using LeftSYieldsImpSYields by metis
 have   4: "\<turnstile> (f \<and>  sfin  (init w)) syields  (init w) " 
   using "1" "3" MP by fastforce
 have   5: "\<turnstile> (f \<and> sfin  (init w))\<frown> g \<and> (f \<and>  sfin  (init w)) syields  (init w)
              \<longrightarrow> (f \<and>  sfin  (init w))\<frown> (g \<and> (init w)) " 
   by (rule SChopAndSYieldsImp)
 have   6: "\<turnstile> (f \<and>  sfin  (init w))\<frown> g \<longrightarrow> (f \<and>  sfin  (init w))\<frown> (g \<and> (init w)) " 
   using "4" "5" by fastforce
 have   7: "\<turnstile> (f \<and>  sfin  (init w))\<frown> (g \<and> (init w)) \<longrightarrow> f\<frown> (g \<and> (init w)) " 
   by (rule AndSChopA)
 have   8: "\<turnstile> g \<and> (init w) \<longrightarrow> (init w) \<and> g " 
   by auto
 hence  9: "\<turnstile> f\<frown> (g \<and> (init w)) \<longrightarrow> f \<frown>((init w) \<and> g) " 
   by (rule RightSChopImpSChop)
 have  10: "\<turnstile> (f \<and>  sfin  (init w))\<frown> g \<longrightarrow> f\<frown> ((init w) \<and> g) " 
   using "6" "7" "9" by fastforce
 have  11: "\<turnstile> (f \<and> finite) \<longrightarrow> (f \<and>  sfin  (init w)) \<or>   (f \<and> sfin (\<not>  (init w))) " 
   using AndFiniteImpAndSFinStateOrSFinNotState by blast
 hence 12: "\<turnstile> f\<frown>  ((init w) \<and> g) \<longrightarrow>
              ((f \<and>  sfin  (init w)) \<or>  (f \<and> sfin (\<not>  (init w)) ))\<frown> ((init w) \<and> g) " 
   by (metis FiniteImp LeftChopImpChop inteq_reflection schop_d_def) 
 have  13: "\<turnstile> ((f \<and>  sfin  (init w))\<or>  (f \<and> sfin (\<not>  (init w))))\<frown> ((init w) \<and> g)
              =  
              ((f \<and> sfin (init w))\<frown> ((init w) \<and> g) \<or>  (f \<and> sfin (\<not>  (init w)))\<frown>((init w) \<and> g)) " 
   by (rule OrSChopEqv)
 have  14: "\<turnstile> ( f \<and> sfin   (init (\<not> w)))\<frown> ((init w) \<and> g) \<longrightarrow> \<diamond>( (init (\<not> w)) \<and> ((init w) \<and> g)) " 
   using SFinSChopEqvDiamond 
   by (metis SChopImpSChop Prop12 int_iffD1 inteq_reflection lift_and_com)
 have 141: "\<turnstile> \<not>( \<diamond>(  (init (\<not> w)) \<and> ((init w) \<and> g))) \<longrightarrow> 
              \<not> ( ( f \<and> sfin   (init (\<not> w)))\<frown> ((init w) \<and> g))" 
   using "14" by fastforce
 have 150: "\<turnstile> ((init (\<not> w)) \<and> ((init w) \<and> g)) = #False"
   using Initprop(2) by fastforce 
 have  15: "\<turnstile> \<not>( \<diamond>(  (init (\<not> w)) \<and> ((init w) \<and> g))) "
   by (metis "150" NotDiamondAndNot int_eq int_simps(21)) 
 have 151: "\<turnstile> \<not> ( ( f \<and> sfin   (init (\<not> w)))\<frown> ((init w) \<and> g))" 
   using "15" "141" by fastforce
 have 1511: "\<turnstile> ( f \<and> sfin (\<not>  (init w)))\<frown> ((init w) \<and> g) \<longrightarrow> #False" 
   using "151"  by (metis Initprop(2) int_simps(14) inteq_reflection) 
 have 152: "\<turnstile> (f \<and> sfin(init w))\<frown> ((init w) \<and> g) \<or>  (f \<and> sfin (\<not>(init w)))\<frown>((init w) \<and> g) \<longrightarrow>
              (f \<and>  sfin  (init w))\<frown> ((init w) \<and> g)" 
   using "1511" by fastforce
 have  16: "\<turnstile> f\<frown> ((init w) \<and> g) \<longrightarrow> (f \<and>  sfin  (init w))\<frown> ((init w) \<and> g) " 
   using "12" "13" "152" by fastforce
 have  17: "\<turnstile> (f\<and>  sfin  (init w))\<frown> ((init w) \<and> g) \<longrightarrow> (f\<and>  sfin  (init w))\<frown> g " 
   by (rule SChopAndB)
 have  18: "\<turnstile> f\<frown> ((init w) \<and> g) \<longrightarrow> (f \<and>  sfin  (init w))\<frown> g " 
   using "16" "17" by fastforce
 from 10 18 show ?thesis by fastforce
qed

lemma DfAndSFinEqvSChopState:
 "\<turnstile>    df (f \<and>  sfin  (init w)) = f\<frown> (init w) "
proof -
 have  1: "\<turnstile> (f \<and> sfin(init w))\<frown> #True = f\<frown>((init w) \<and> #True) " 
   by (rule AndSFinSChopEqvStateAndSChop)
 have  2: "\<turnstile> ((init w) \<and> #True) = (init w) " 
   by auto
 hence 3: "\<turnstile> (f\<frown> ((init w) \<and> #True)) = (f\<frown> (init w))" 
   by (rule RightSChopEqvSChop)
 have  4: "\<turnstile> (f \<and>  sfin  (init w))\<frown> #True = f\<frown> (init w) " 
   using "1" "3" by auto
 from 4 show ?thesis by (simp add: df_d_def)
qed

lemma SFinNotStateEqvNotSFinState:
 "\<turnstile> finite \<longrightarrow>  (\<not>( sfin   (init w)) ) = (sfin   (init (\<not> w))  )"
using SFinEqvTrueSChopAndEmpty 
by (metis Initprop(2) SFinprop(3) int_eq)

lemma BfImpSFinEqvSYieldsState:
 "\<turnstile>   bf (f  \<longrightarrow>  sfin  (init w)) = f  syields  (init w) "
proof -
 have  1: "\<turnstile>  df (f  \<and> sfin (init (\<not> w))) = f\<frown>   (init (\<not> w)) " 
   by (rule DfAndSFinEqvSChopState)
 have  2: "\<turnstile> finite \<longrightarrow> (f \<and> sfin(init (\<not> w)))  = (f \<and> \<not>(sfin(init w))) " 
   using SFinNotStateEqvNotSFinState by fastforce
 have  3: "\<turnstile> (f \<and> \<not> (sfin(init w))) = (\<not> (f \<longrightarrow>  sfin  (init w))) " 
   by auto
 have  4: "\<turnstile> finite \<longrightarrow> (f \<and> sfin(init  (\<not> w))) = (\<not> (f \<longrightarrow>  sfin(init w)))" 
   using "2" "3" by fastforce
 hence 5: "\<turnstile>  df (f  \<and>  sfin   (init (\<not> w))) =  df (\<not> (f \<longrightarrow> sfin(init w))) " 
   by (metis DfEqvNotBfNot FiniteImpAnd df_d_def inteq_reflection schop_d_def)
 have  6: "\<turnstile>  df (\<not> (f  \<longrightarrow>  sfin  (init w))) = (\<not>( bf (f \<longrightarrow> sfin(init w))))" 
   by (rule DfNotEqvNotBf)
 have  7: "\<turnstile> \<not> (bf (f  \<longrightarrow>  sfin  (init w))) = f\<frown>(init (\<not> w)) " 
   using "1"  "5" "6" Initprop by fastforce
 hence 8: "\<turnstile> bf (f  \<longrightarrow>  sfin  (init w)) = (\<not> (f \<frown> (\<not>  (init w)))) " 
   by (metis Initprop(2) int_eq int_simps(7))
 from 8 show ?thesis by (simp add: syields_d_def)
qed

lemma StateImpSYields:
 assumes " \<turnstile>   (init w) \<and> f \<longrightarrow>  sfin  (init w1) "
 shows   "\<turnstile> (init w) \<longrightarrow> (f syields  (init w1)) "
proof -
 have  1: "\<turnstile> (init w) \<and> f  \<longrightarrow>  sfin  (init w1) " using assms by auto
 hence 2: "\<turnstile> (init w) \<longrightarrow> (f  \<longrightarrow>  sfin  (init w1)) " by auto
 hence 3: "\<turnstile> (init w) \<longrightarrow> bf (f  \<longrightarrow>  sfin  (init w1)) "  using StateImpBfGen by auto
 have  4: "\<turnstile> bf (f  \<longrightarrow>  sfin  (init w1)) = f syields  (init w1) " by (rule BfImpSFinEqvSYieldsState)
 from 3 4 show ?thesis by fastforce
qed

lemma StateAndSYieldsImpSYields:
 assumes "\<turnstile>   (init w) \<and> f \<longrightarrow> f1 "
 shows   "\<turnstile> (init w) \<and> (f1 syields  g) \<longrightarrow> (f syields  g) "
proof -
 have  1: "\<turnstile> (init w) \<and> f \<longrightarrow> f1 " using assms by auto
 hence 2: "\<turnstile> (init w) \<and> (f\<frown> (\<not>  g)) \<longrightarrow> f1\<frown> (\<not>  g) " by (rule StateAndSChopImpSChopRule)
 hence 3: "\<turnstile> (init w) \<and> \<not> (f1\<frown> (\<not>  g)) \<longrightarrow> \<not> (f\<frown> (\<not>  g)) " by auto
 from 3 show ?thesis by (simp add: syields_d_def)
qed

lemma AndSYieldsA:
 "\<turnstile>   f syields  g \<longrightarrow> (f \<and> f1) syields  g "
proof -
 have 1: "\<turnstile> f \<and> f1 \<longrightarrow> f " by auto
 from 1 show ?thesis by (rule LeftSYieldsImpSYields)
qed

lemma AndSYieldsB:
 " \<turnstile>   f1 syields  g \<longrightarrow> (f \<and> f1) syields  g "
proof -
 have 1: "\<turnstile> f \<and> f1 \<longrightarrow> f1 " by auto
 from 1 show ?thesis by (rule LeftSYieldsImpSYields)
qed

lemma RightSYieldsImpSYields:
 assumes "\<turnstile>   g\<longrightarrow> g1 "
 shows   "\<turnstile> (f syields  g) \<longrightarrow> (f syields  g1) "
proof -
 have  1: "\<turnstile> g \<longrightarrow> g1 " using assms by auto
 hence 2: " \<turnstile> \<not>  g1 \<longrightarrow> \<not>  g" by auto
 hence 3: "\<turnstile> f\<frown> (\<not>  g1) \<longrightarrow> f\<frown> (\<not>  g) " by (rule RightSChopImpSChop)
 hence 4: "\<turnstile> \<not> (f\<frown> (\<not>  g)) \<longrightarrow> \<not> (f\<frown> (\<not>  g1)) " by auto
 from 4 show ?thesis by (simp add: syields_d_def)
qed

lemma RightSYieldsEqvSYields:
 assumes "\<turnstile>   g = g1 "
 shows   "\<turnstile> (f syields  g) = (f syields  g1) "
proof -
 have  1: "\<turnstile> g = g1 " using assms by auto
 hence 2: "\<turnstile> (\<not>  g) = (\<not>  g1) " by auto
 hence 3: "\<turnstile> f\<frown> (\<not>  g) = f\<frown> (\<not>  g1) " by (rule RightSChopEqvSChop)
 hence 4: "\<turnstile> (\<not> (f\<frown> (\<not>  g))) = (\<not> (f\<frown> (\<not>  g1))) " by auto
 from 4 show ?thesis by (simp add: syields_d_def)
qed

lemma BoxImpSYields:
 "\<turnstile>   \<box> g \<longrightarrow> f syields  g "
proof -
 have  1: "\<turnstile> f\<frown> (\<not>  g) \<longrightarrow> \<diamond>(\<not>  g) " by (rule SChopImpDiamond)
 hence 2: "\<turnstile> \<not> (\<diamond>(\<not>  g)) \<longrightarrow> \<not> (f\<frown> (\<not>  g)) " by auto
 from 2 show ?thesis by (simp add: syields_d_def always_d_def)
qed

lemma BoxEqvTrueSYields:
 "\<turnstile>   \<box> f = #True syields  f "
proof -
 have  1: "\<turnstile> #True\<frown> (\<not>  f) = \<diamond> (\<not>  f) " by (rule TrueSChopEqvDiamond)
 hence 2: "\<turnstile> (\<not> (#True\<frown> (\<not>  f))) = (\<not>( \<diamond> (\<not>  f))) " by auto
 have  3: "\<turnstile> \<box> f = (\<not> ( \<diamond> (\<not>  f))) " by (simp add: always_d_def)
 have  4: "\<turnstile> \<box> f = (\<not> (#True\<frown> (\<not>  f))) " using "2" "3" by fastforce
 from 4 show ?thesis by (simp add: syields_d_def)
qed

lemma SYieldsGen:
 assumes "\<turnstile>   g "
 shows   "\<turnstile> f syields  g "
proof -
  have  1: "\<turnstile> g " using assms by auto
  hence 2: "\<turnstile> \<box> g " by (rule BoxGen)
  have  3: "\<turnstile> \<box> g \<longrightarrow> f syields  g " by (rule BoxImpSYields)
  from 2 3 show ?thesis using MP by fastforce
qed

lemma SYieldsAndSYieldsEqvSYieldsAnd:
  "\<turnstile>   ((f syields  g) \<and> (f  syields  g1)) = f syields (g \<and> g1) "
proof -
 have  1: "\<turnstile> f\<frown> (\<not>  g \<or>  \<not>  g1) = ((f\<frown> (\<not>  g)) \<or>  (f\<frown> (\<not>  g1))) " by (rule SChopOrEqv)
 hence 2: "\<turnstile> ((f\<frown> (\<not>  g)) \<or>  (f\<frown> (\<not>  g1))) = f\<frown> (\<not>  g \<or>  \<not>  g1) " by auto
 have  3: "\<turnstile> (\<not>  g \<or>  \<not>  g1)  =  (\<not> (g \<and> g1)) " by auto
 hence 4: "\<turnstile> f\<frown> (\<not>  g \<or>  \<not>  g1)  =  f\<frown> (\<not> (g \<and> g1)) " by (rule RightSChopEqvSChop)
 have  5: "\<turnstile> (f\<frown> (\<not>  g)) \<or>  (f\<frown> (\<not>  g1)) = f\<frown> (\<not> (g \<and> g1)) " using "2" "4" by fastforce
 hence 6: "\<turnstile> (\<not> (f\<frown> (\<not>  g)) \<and> \<not> (f\<frown> (\<not>  g1))) = (\<not> (f\<frown> (\<not> (g \<and> g1)))) " using "1" "4" by fastforce 
 from 6 show ?thesis by (simp add: syields_d_def)
qed

lemma SYieldsAndSYieldsImpAndSYieldsAnd:
 "\<turnstile>   (f syields  g) \<and> (f1 syields  g1) \<longrightarrow> (f\<and> f1) syields (g \<and> g1) "
proof -
 have 1: "\<turnstile> f syields  g \<longrightarrow> (f \<and> f1) syields  g" 
   by (rule AndSYieldsA)
 have 2: "\<turnstile> f1 syields  g1 \<longrightarrow> (f \<and> f1) syields  g1 " 
   by (rule AndSYieldsB)
 have 3: "\<turnstile> ((f \<and> f1) syields  g \<and> (f \<and> f1) syields  g1) = (f \<and> f1) syields  (g \<and> g1) " 
   by (rule SYieldsAndSYieldsEqvSYieldsAnd)
 from 1 2 3 show ?thesis by fastforce
qed

lemma SYieldsSYieldsEqvSChopSYields:
 "\<turnstile>   f syields (g syields  h) = (f\<frown> g) syields h  " 
proof -
 have  1: "\<turnstile> f\<frown> (g\<frown> (\<not>  h)) = (f\<frown> g)\<frown> (\<not>  h)   " by (rule SChopAssoc)
 hence 2: "\<turnstile> f\<frown> (g\<frown> (\<not>  h)) = (f\<frown> g)\<frown> (\<not>  h) " by auto
 have  3: "\<turnstile> g\<frown> (\<not>  h) = (\<not> \<not> (g\<frown> (\<not>  h))) " by auto
 hence 4: "\<turnstile> f\<frown> (g\<frown> (\<not>  h)) = f\<frown> (\<not> \<not> (g\<frown> (\<not>  h))) " by (rule RightSChopEqvSChop)
 have  5: "\<turnstile> f\<frown> (\<not> \<not> (g\<frown> (\<not>  h))) = (f\<frown> g)\<frown> (\<not>  h) " using "2" "4" by auto
 hence 6: "\<turnstile> f\<frown> (\<not> (g syields  h)) = (f\<frown> g)\<frown> (\<not>  h) " by (simp add: syields_d_def)
 hence 7: "\<turnstile> (\<not> (f\<frown> (\<not> (g syields  h)))) = (\<not> ((f\<frown> g)\<frown> (\<not>  h))) " by auto
 from 7 show ?thesis by (simp add: syields_d_def)
qed

lemma EmptySYields:
 "\<turnstile>    empty   syields  f = f "
proof -
 have  1: "\<turnstile>  empty \<frown> (\<not>  f) = (\<not>  f) " by (rule EmptySChop)
 hence 2: "\<turnstile> (\<not> ( empty \<frown> (\<not>  f))) = f " by auto
 from 2 show ?thesis by (simp add: syields_d_def)
qed

lemma NextSYields:
 "\<turnstile>   (\<circle> f) syields  g = wnext (f syields  g) "
proof -
 have  1: "\<turnstile> (\<circle> f)\<frown> (\<not>  g) = \<circle>(f\<frown> (\<not>  g)) " by (rule NextSChop)
 hence 2: "\<turnstile> (\<not> ((\<circle> f)\<frown> (\<not>  g))) = (\<not> (\<circle>(f\<frown> (\<not>  g)))) " by auto
 hence 3: "\<turnstile> (\<circle> f) syields  g = (\<not> (\<circle>(f\<frown> (\<not>  g)))) " by (simp add: syields_d_def)
 have  4: "\<turnstile> (\<not>( \<circle>(f\<frown> (\<not>  g)))) = wnext (\<not> (f\<frown> (\<not>  g))) " by (auto simp: wnext_d_def)
 have  5: "\<turnstile> (\<circle> f) syields  g = wnext (\<not> (f\<frown> (\<not>  g))) " using "3" "4" by fastforce
 from 5 show ?thesis by (simp add: syields_d_def)
qed

lemma SkipSChopEqvNext:
 " \<turnstile>    skip \<frown> f = \<circle> f "
by (meson NextSChopdef Prop11)

lemma SkipSYieldsEqvWeakNext:
 "\<turnstile>    skip  syields  f = wnext  f "
proof -
 have  1: "\<turnstile>  skip \<frown> (\<not>  f) = \<circle>(\<not>  f) " by (rule SkipSChopEqvNext)
 hence 2: "\<turnstile> (\<not> ( skip \<frown> (\<not>  f))) = (\<not>( \<circle>(\<not>  f))) " by auto
 have  3: "\<turnstile> (\<not> (\<circle>(\<not>  f))) = wnext  f " by (auto simp: wnext_d_def)
 have  4: "\<turnstile> (\<not> ( skip \<frown> (\<not>  f))) = wnext  f " using "2" "3" by fastforce
 from 4 show ?thesis by (simp add: syields_d_def)
qed

lemma NextImpSkipSYields:
 "\<turnstile>   \<circle> f \<longrightarrow>  skip  syields  f "
proof -
 have 1: "\<turnstile> \<circle> f \<longrightarrow> wnext  f " using WnextEqvEmptyOrNext by fastforce
 have 2: "\<turnstile>  skip  syields  f = wnext  f " by (rule SkipSYieldsEqvWeakNext)
 from 1 2 show ?thesis by fastforce
qed

lemma MoreEqvSkipSChopTrue:
 "\<turnstile>    more  =  skip \<frown> #True"
proof -
 have  1: "\<turnstile>  skip \<frown> #True = \<circle>#True " by (rule SkipSChopEqvNext)
 hence 2: "\<turnstile> \<circle>#True =  skip \<frown> #True " by auto
 from 2 show ?thesis by (simp add: more_d_def)
qed

lemma MoreSChopImpMore:
 "\<turnstile>    more \<frown> f \<longrightarrow>  more "
proof -
 have 1: "\<turnstile> (\<circle>#True)\<frown> f = \<circle>(#True\<frown> f)" 
   by (rule NextSChop)
 have 2: "\<turnstile> \<circle>(#True\<frown> f) \<longrightarrow>  more "
   by (metis DiIntro LeftChopImpMoreRule di_d_def more_d_def next_d_def) 
 have 3: "\<turnstile> (\<circle>#True\<frown> f) \<longrightarrow>  more " 
   using "1" "2" by fastforce
 from 3 show ?thesis by (metis more_d_def)
qed

lemma MoreSChopImpFmore:
 "\<turnstile>    more \<frown> (f \<and> finite) \<longrightarrow>  fmore "
proof -
 have 1: "\<turnstile> more \<frown> (f \<and> finite)= \<circle>(#True\<frown> (f \<and> finite))" 
   by (simp add: NextSChop more_d_def)
 have 2: "\<turnstile> \<circle>(#True\<frown> (f \<and> finite)) \<longrightarrow>  fmore "
   by (metis "1" FmoreChopImpFmore fmore_d_def int_eq schop_d_def) 
 from 1 2  show ?thesis by fastforce
qed

lemma SChopMoreImpMore:
 "\<turnstile>   f\<frown>  more  \<longrightarrow>  more  "
proof -
 have 1: "\<turnstile> f \<frown>  more  \<longrightarrow> \<diamond> more " by (rule SChopImpDiamond)
 have 2: "\<turnstile> \<diamond> more  \<longrightarrow>  more " by (simp add: FiniteChopMoreEqvMore int_iffD1 sometimes_d_def)
 from 1 2 show ?thesis  by fastforce
qed

lemma MoreSChopEqvNextDiamond:
 "\<turnstile>    more \<frown> f = \<circle>(\<diamond> f) "
proof -
 have 1: "\<turnstile>  more \<frown> f = (\<circle> #True)\<frown> f " by (simp add: more_d_def) 
 have 2: "\<turnstile> (\<circle> #True)\<frown> f = \<circle>(#True\<frown> f) " by (rule NextSChop)
 have 3: "\<turnstile>  more \<frown> f = \<circle>(#True\<frown> f) " using "1" "2" by fastforce
 from 3 show ?thesis by (metis TrueSChopEqvDiamond inteq_reflection)
qed

lemma WeakNextBoxImpMoreSYields:
 "\<turnstile>    more  syields  f = wnext( \<box> f) "
proof - 
 have 1: "\<turnstile> more \<frown> (\<not> f) = \<circle>(\<diamond> (\<not>f)) " by (rule MoreSChopEqvNextDiamond)
 have 2: "\<turnstile> \<circle>(\<diamond> (\<not>f)) = \<circle>(\<not>(\<box>f))" by (auto simp: always_d_def)
 have 3: "\<turnstile> \<circle>(\<not>(\<box>f)) = (\<not> ( wnext( \<box> f) ))" by (auto simp: wnext_d_def)
 have 4: "\<turnstile> more \<frown> (\<not> f)  = (\<not>(more  syields  f))" by (simp add: syields_d_def) 
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma NotEqvSYieldsMore:
 "\<turnstile> finite \<longrightarrow>  (\<not>  f) = f syields  more  "
proof -
 have  1: "\<turnstile> finite \<longrightarrow> f\<frown>  empty  = f " by (rule SChopEmpty)
 hence 2: "\<turnstile> finite \<longrightarrow> (\<not> (f\<frown>  empty )) = (\<not>  f) " by auto
 have  3: "\<turnstile>  empty  = (\<not>  more) " by (auto simp: empty_d_def)
 hence 4: "\<turnstile> f\<frown>  empty  = f\<frown> (\<not>  more) " by (rule RightSChopEqvSChop)
 hence 5: "\<turnstile> (\<not> (f\<frown>  empty )) = (\<not> (f\<frown> (\<not>  more ))) " by auto
 have  6: "\<turnstile> finite \<longrightarrow> (\<not>  f) = (\<not> (f\<frown> (\<not>  more) )) " using "2" "5" by fastforce
 from 6 show ?thesis by (metis syields_d_def)
qed

lemma LeftSChopImpMoreRule:
 assumes "\<turnstile> f \<longrightarrow>  more "
 shows   "\<turnstile> f\<frown> g \<longrightarrow>  more "
proof -
 have  1: "\<turnstile> f \<longrightarrow>  more " using assms by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow>  more \<frown> g " by (rule LeftSChopImpSChop)
 have 3: " \<turnstile>  more \<frown> g \<longrightarrow>  more " by (rule MoreSChopImpMore)
 from 2 3 show ?thesis using lift_imp_trans by blast
qed

lemma LeftSChopImpFMoreRule:
 assumes "\<turnstile> f \<longrightarrow>  fmore "
 shows   "\<turnstile> f\<frown> (g \<and> finite) \<longrightarrow>  fmore "
proof -
 have  1: "\<turnstile> f \<longrightarrow>  fmore " 
   using assms by auto
 hence 2: "\<turnstile> f\<frown> (g \<and> finite) \<longrightarrow>  more \<frown> (g \<and> finite) " 
   by (metis FiniteChopSkipEqvFiniteAndMore FiniteChopSkipEqvSkipChopFinite 
       FmoreEqvSkipChopFinite LeftSChopImpSChop Prop12 inteq_reflection)
 have 3: " \<turnstile>  more \<frown> (g \<and> finite) \<longrightarrow>  fmore " 
   using MoreSChopImpFmore by fastforce
 from 2 3 show ?thesis using lift_imp_trans by blast
qed

lemma RightSChopImpMoreRule:
 assumes "\<turnstile>   g \<longrightarrow>  more "
 shows   "\<turnstile> f\<frown> g \<longrightarrow>  more "
proof -
 have  1: "\<turnstile> g \<longrightarrow>  more " using assms by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> f\<frown>  more " by (rule RightSChopImpSChop)
 have  3: "\<turnstile> f\<frown>  more  \<longrightarrow>  more " by (rule SChopMoreImpMore)
 from 2 3 show ?thesis using lift_imp_trans by blast
qed

lemma NotDfEqvBfNot:
 "\<turnstile>   (\<not> ( df  f)) = bf (\<not>  f) "
proof -
 have  1: "\<turnstile> f = (\<not> \<not>  f) " by auto
 hence 2: "\<turnstile>  df  f =  df (\<not> \<not>  f)" by (rule DfEqvDf)
 hence 3: "\<turnstile> (\<not>  ( df  f)) = (\<not> ( df (\<not> \<not>  f)))" by auto
 from 3 show ?thesis by (simp add: bf_d_def)
qed

(* T19 *)
lemma SChopImpDf:
 "\<turnstile>   f\<frown> g \<longrightarrow>  df  f "
proof -
 have  1: "\<turnstile> g \<longrightarrow> #True " by auto
 hence 2: "\<turnstile> f\<frown> g \<longrightarrow> f\<frown> #True " by (rule RightSChopImpSChop)
 from 2 show ?thesis by (simp add: df_d_def)
qed

lemma TrueEqvTrueSChopTrue:
 "\<turnstile>   #True = #True\<frown> #True "
proof -
 have  1: "\<turnstile> #True\<frown> #True \<longrightarrow> #True" 
   by auto
 have  2: "\<turnstile> #True \<longrightarrow> #True\<frown> #True " 
   by (metis DfState Initprop(4) df_d_def int_eq_true int_iffD1 inteq_reflection)
 from 1 2 show ?thesis by auto
qed

(* T43 *)
lemma DfEqvDfDf:
 "\<turnstile>    df  f =  df (  df  f) "
proof -
 have  1: "\<turnstile> #True = #True\<frown> #True " by (rule TrueEqvTrueSChopTrue)
 hence 2: "\<turnstile> f\<frown> #True = f\<frown> (#True\<frown> #True) " by (rule RightSChopEqvSChop)
 have  3: "\<turnstile> f\<frown> (#True\<frown> #True)= (f\<frown> #True)\<frown> #True   " by (rule SChopAssoc)
 have  4: "\<turnstile> f\<frown> #True = (f\<frown> #True)\<frown> #True " using "2" "3"  by fastforce 
 from 4 show ?thesis by (metis df_d_def)
qed

(* T46 *)
lemma BfEqvBfBf:
 "\<turnstile>   bf f = bf( bf  f) "
proof -
 have  1: "\<turnstile>  df (\<not>  f) =  df(  df (\<not>  f)) " by (rule DfEqvDfDf)
 have  2: "\<turnstile>  df (\<not>  f) = (\<not> ( bf  f)) " by (rule DfNotEqvNotBf)
 hence 3: "\<turnstile>  df ( df (\<not>  f)) =  df (\<not> ( bf  f)) " by (rule DfEqvDf)
 have  4: "\<turnstile>  df (\<not>  f) =  df (\<not>(  bf  f)) " using "1" "3"  by fastforce 
 hence 5: "\<turnstile> (\<not> ( df (\<not>  f))) = (\<not> ( df (\<not> ( bf  f)))) " by fastforce
 from 5 show ?thesis by (metis bf_d_def)
qed

(* T47 *)
lemma BfImpBfBf:
 "\<turnstile> bf f \<longrightarrow> bf(bf f)"
proof -
 have 1: "\<turnstile> bf(bf f) = bf f" using BfEqvBfBf by fastforce
 from 1 show ?thesis by (simp add: int_iffD2)
qed

(* T34 *)
lemma DfOrEqv:
 "\<turnstile>    df (f \<or>  g) =  (df  f \<or>   df  g) " 
proof -
 have 1: "\<turnstile> (f \<or>  g)\<frown> #True = (f\<frown> #True \<or>  g\<frown> #True) " by (rule OrSChopEqv)
 from 1 show ?thesis by (simp add: df_d_def)
qed

lemma DfAndA:
 "\<turnstile>    df (f \<and> g) \<longrightarrow>  df  f "
proof -
 have 1: "\<turnstile> (f \<and> g)\<frown> #True \<longrightarrow> f\<frown> #True " by (rule AndSChopA)
 from 1 show ?thesis by (simp add: df_d_def)
qed

lemma DfAndB:
 "\<turnstile>    df (f \<and> g) \<longrightarrow>  df  g "
proof -
 have 1: "\<turnstile> (f \<and> g)\<frown> #True \<longrightarrow> g\<frown> #True " by (rule AndSChopB)
 from 1 show ?thesis by (simp add: df_d_def)
qed

lemma DfAndImpAnd:
 "\<turnstile>    df (f \<and> g) \<longrightarrow>  df  f \<and>  df  g "  
proof -
 have 1: "\<turnstile>  df (f \<and> g) \<longrightarrow>  df  f " by (rule DfAndA)
 have 2: "\<turnstile>  df (f \<and> g) \<longrightarrow>  df  g " by (rule DfAndB)
 from 1 2 show ?thesis by fastforce
qed

lemma DfSkipEqvMore:
 "\<turnstile>    df  skip  =  more "
proof -
 have 1: "\<turnstile>  skip \<frown> #True = \<circle>#True " by (rule SkipSChopEqvNext)
 have 2: "\<turnstile> \<circle>#True =  more " by (auto simp: more_d_def)
 have 3: "\<turnstile>  skip \<frown> #True =  more " using "1" "2" by fastforce
 from 3 show ?thesis by (simp add: df_d_def)
qed

lemma DfMoreEqvMore:
 "\<turnstile>    df  more  =  more "
proof -
 have  1: "\<turnstile>  df (\<circle> #True ) = \<circle>( df #True) " by (rule DfNext)
 have  2: "\<turnstile> \<circle>( df  #True)  \<longrightarrow>  more "
 by (metis ChopImpDi di_d_def more_d_def next_d_def) 
 have  3: "\<turnstile>  df( \<circle> #True)  \<longrightarrow>  more " using "1" "2" by fastforce
 hence 4: "\<turnstile>  df  more  \<longrightarrow>  more " by (simp add: more_d_def)
 have  5: "\<turnstile>  more  \<longrightarrow>  df  more " 
 by (metis "1" "4" TrueEqvTrueSChopTrue df_d_def inteq_reflection more_d_def)
 from 4 5 show ?thesis by fastforce
qed

lemma DfIfEqvRule:
 assumes "\<turnstile>   f =  if\<^sub>i  (init w)  then  g  else  h "
 shows   "\<turnstile>  df  f =  if\<^sub>i  (init w)  then  ( df  g)  else   (df  h) "
proof -
 have  1: "\<turnstile> f =  if\<^sub>i  (init w)  then  g  else  h " using assms by auto
 hence 2: "\<turnstile> f\<frown> #True =  if\<^sub>i (init w) then (g\<frown> #True) else (h\<frown> #True) " by (rule IfSChopEqvRule)
 from 2 show ?thesis by (simp add: df_d_def)
qed

lemma SDaNotEqvNotSBa:
 "\<turnstile>    sda (\<not>  f) = (\<not> ( sba  f)) "
proof -
 have 1: "\<turnstile>  sba  f = (\<not> ( sda (\<not>  f))) " by (simp add: sba_d_def)
 from 1 show ?thesis by fastforce
qed

lemma SDaEqvSDa:
 assumes "\<turnstile>   f = g "
 shows "\<turnstile> sda  f =  sda  g "
using assms using int_eq by force

lemma SDaEqvNotSBaNot:
 "\<turnstile>    sda  f = (\<not> ( sba (\<not>  f))) "
proof -
 have  1: "\<turnstile>  sba (\<not>  f) = (\<not> ( sda (\<not> \<not>  f)))" by (simp add: sba_d_def)
 hence 2: "\<turnstile>  sda (\<not> \<not>  f) = (\<not>(  sba (\<not>  f))) " by fastforce
 have  3: "\<turnstile> f = (\<not> \<not>  f) " by simp
 hence 4: "\<turnstile>  sda  f =  sda  (\<not> \<not>  f) " by (rule SDaEqvSDa)
 from 2 4 show ?thesis by simp
qed

lemma SBaElim:
 "\<turnstile>    sba f \<and> finite \<longrightarrow> f "
proof -
 have  1: "\<turnstile>  sba  f = \<box>(bf  f) " 
   by (rule SBaEqvBtBf)
 have  2: "\<turnstile> bf  f \<and> finite \<longrightarrow> f " 
   by (rule BfElim)
 hence 3: "\<turnstile> \<box>(bf  f \<and> finite \<longrightarrow> f) " 
   by (rule BoxGen)
 have  4: "\<turnstile> \<box>(bf  f  \<and> finite \<longrightarrow> f) \<longrightarrow> \<box>(bf  f \<and> finite) \<longrightarrow> \<box> f " 
   by (rule BoxImpDist)
 have  5: "\<turnstile> \<box>(bf  f \<and> finite) \<longrightarrow> \<box> f " 
   using "3" "4" MP by fastforce
 have  6: "\<turnstile> \<box>(bf  f \<and> finite) = (\<box>(bf  f) \<and> finite)"
   by (metis (no_types, lifting) BoxEqvFiniteYields FiniteChopInfEqvInf NotChopEqvYieldsNot 
       YieldsAndYieldsEqvYieldsAnd finite_d_def inteq_reflection)
 have  7: "\<turnstile> \<box> f \<longrightarrow> f " 
   by (rule BoxElim)
 from 1 5 6 7 show ?thesis  using SBaImpBt lift_imp_trans by metis
qed

lemma SDaIntro:
 "\<turnstile>   f \<and> finite \<longrightarrow>  sda  f "
proof -
 have  1: "\<turnstile>  sba  (\<not>  f) \<and> finite \<longrightarrow> (\<not>  f) "  by (rule SBaElim)
 hence 2: "\<turnstile> \<not> \<not>  f \<longrightarrow> \<not> (  sba  (\<not>  f) \<and> finite) " by fastforce
 have  3: "\<turnstile> f = (\<not> \<not>  f) " by simp
 have  4: "\<turnstile>  sda  f = (\<not>  ( sba  (\<not>  f))) " by (rule SDaEqvNotSBaNot)
 from 2 3 4 show ?thesis by fastforce
qed

lemma SBaGen:
 assumes "\<turnstile>   f "
 shows   "\<turnstile>  sba  f "
proof -
 have  1: "\<turnstile>   f " using assms by auto
 hence 2: "\<turnstile> \<box> f " by (rule BoxGen)
 hence 3: "\<turnstile> bf( \<box> f) " by (rule BfGen)
 have  4: "\<turnstile>  sba  f = bf (\<box> f) " by (rule SBaEqvBfBt)
 from 3 4 show ?thesis by fastforce
qed

lemma SBaImpDist:
 "\<turnstile>  sba (f \<longrightarrow> g) \<longrightarrow>  sba  f \<longrightarrow>  sba  g "
proof -
 have  1: "\<turnstile> bf (f \<longrightarrow> g) \<longrightarrow> (bf  f \<longrightarrow> bf  g) " 
   by (rule BfImpDist)
 hence 2: "\<turnstile> \<box>(bf (f \<longrightarrow> g) \<longrightarrow> (bf  f \<longrightarrow> bf  g)) " 
   by (rule BoxGen)
 have  3: "\<turnstile> \<box>(bf (f \<longrightarrow> g) \<longrightarrow> (bf  f \<longrightarrow> bf  g))
            \<longrightarrow>  
            (\<box> (bf (f \<longrightarrow> g)) \<longrightarrow> (\<box>(bf  f) \<longrightarrow> \<box>(bf  g))) " 
   by (meson "2" BoxImpDist MP lift_imp_trans Prop01 Prop05 Prop09)
 have  4: "\<turnstile> \<box>(bf (f \<longrightarrow> g)) \<longrightarrow> (\<box>(bf  f) \<longrightarrow> \<box>(bf  g)) " 
   using "2" "3" MP by fastforce
 have  5: "\<turnstile>  sba (f\<longrightarrow> g) = \<box>(bf (f \<longrightarrow> g)) " 
   by (rule SBaEqvBtBf)
 have  6: "\<turnstile>  sba  f = \<box>(bf  f) "
   by (rule SBaEqvBtBf)
 have  7: "\<turnstile>  sba  g = \<box>(bf  g) "
   by (rule SBaEqvBtBf)
 from 4 5 6 7 show ?thesis by fastforce
qed

lemma SBaAndEqv:
 "\<turnstile>    sba (f \<and> g) =  (sba  f \<and>  sba  g) "
proof -
 have  1: "\<turnstile>    sba (f \<and> g) =   \<box>(bf (f \<and> g)) " 
   by (rule SBaEqvBtBf)
 have  2: "\<turnstile>  bf (f \<and> g) = (bf f \<and> bf g) "
   by (simp add: BfAndEqvBfAndBf) 
 hence 3: "\<turnstile> \<box>(bf (f \<and> g)) = \<box>(bf f \<and> bf g) " 
   using BoxEqvBox by blast
 have  4: "\<turnstile> \<box>(bf f \<and> bf g)= (\<box>(bf f)  \<and> \<box>(bf g)) " 
   by (metis "2" BoxAndBoxEqvBoxRule inteq_reflection)
 have  5: "\<turnstile> sba  f = \<box>(bf  f) " 
   by (rule SBaEqvBtBf)
 have  6: "\<turnstile>  sba  g = \<box>(bf  g) " 
   by  (rule SBaEqvBtBf)
 from 1 3 4 5 6 show ?thesis by  fastforce
qed

lemma SBaImpSBaEqvSBa:
 "\<turnstile>   sba (f = g) \<longrightarrow>  (sba  f =  sba  g) "
proof -
 have  1: "\<turnstile>  sba (f \<longrightarrow> g) \<longrightarrow>  sba  f \<longrightarrow>  sba  g " 
   by (rule SBaImpDist)
 have  2: "\<turnstile>  sba (g \<longrightarrow> f) \<longrightarrow>  sba  g \<longrightarrow>  sba  f " 
   by (rule SBaImpDist)
 have  3: "\<turnstile>  (f = g) =  ((f \<longrightarrow> g) \<and> (g \<longrightarrow> f)) " 
   by auto
 hence 31: "\<turnstile> sba(f = g) =  sba ((f \<longrightarrow> g) \<and> (g \<longrightarrow> f))"
   using inteq_reflection by force
 have  4: "\<turnstile> sba ((f \<longrightarrow> g) \<and> (g \<longrightarrow> f)) = (sba((f \<longrightarrow> g)) \<and> sba((g \<longrightarrow> f))) " 
   by (rule SBaAndEqv) 
 have  5: "\<turnstile> ((sba  f \<longrightarrow>  sba  g) \<and> (sba  g \<longrightarrow>  sba  f)) = (sba  f =  sba  g) "
    by auto
 from 1 2 31 4 5 show ?thesis  by fastforce
qed

lemma SBaImpSBa:
 assumes "\<turnstile>   f \<longrightarrow> g"
 shows   "\<turnstile> sba  f \<longrightarrow>  sba  g"
using SBaGen SBaImpDist MP assms by metis

lemma SBaEqvSBa: 
 assumes "\<turnstile>   f = g"
 shows   "\<turnstile> sba  f =  sba  g"
using SBaGen SBaImpSBaEqvSBa MP assms by metis

lemma SDaImpSDa:
 assumes "\<turnstile>   f \<longrightarrow> g"
 shows   "\<turnstile> sda  f \<longrightarrow>  sda  g"
using assms by (metis SDaEqvDtDf DfAndB DiamondImpDiamond inteq_reflection Prop10)

lemma SDaEqvSDaSDa:
  "\<turnstile>   sda  f =  sda (  sda  f)"
proof -
 have  1: "\<turnstile>  sda  f = \<diamond>( df  f)" 
   by (rule SDaEqvDtDf)
 have  2: "\<turnstile>  df  f =  (df ( df  f))"  
   by (rule DfEqvDfDf)
 hence 3: "\<turnstile> \<diamond> ( df  f) = \<diamond> (df  (df  f))" 
   by (rule DiamondEqvDiamond)
 have  4: "\<turnstile> \<diamond>  (df  f) = \<diamond>(\<diamond> (df  (df  f)))" 
   using DiamondEqvDiamondDiamond DfEqvDfDf using "3" by fastforce
 have  5: "\<turnstile> \<diamond>  (df  (df  f)) =  df (\<diamond>  (df  f))"  
   by (rule DtDfEqvDfDt)
 hence 6: "\<turnstile> \<diamond>(\<diamond>  (df  (df  f))) = \<diamond> (df (\<diamond>  (df  f)))" 
   by (rule DiamondEqvDiamond)
 have  7: "\<turnstile>  sda  f = \<diamond> (df( \<diamond> ( df  f)))" 
   using "1" "3" "4" "6" by fastforce
 have  8: "\<turnstile>  sda (\<diamond> ( df  f)) = \<diamond>( df (\<diamond>  (df  f)))" 
   by (rule SDaEqvDtDf)  
 have  9: "\<turnstile>  sda ( sda  f) =  sda (\<diamond>  (df  f))" 
   using 1 by (rule SDaEqvSDa)
 from 7 8 9 show ?thesis by fastforce
qed

lemma SBaEqvSBaSBa:
 "\<turnstile>    sba  f =  sba  (sba  f)"
proof -
 have 1: "\<turnstile>  sda (\<not>  f) =  sda  (sda (\<not>  f))" by (rule SDaEqvSDaSDa)  
 have 2: "\<turnstile>  sda  (sda (\<not>  f)) = (\<not>  (sba (\<not>  (sda (\<not>  f)))))"  by (rule SDaEqvNotSBaNot)  
 have 3: "\<turnstile> (\<not>  (sda  (sda (\<not>  f)))) =  sba (\<not>  (sda (\<not>  f)))" by (auto simp: sba_d_def)  
 have 4: "\<turnstile> (\<not>  (sda (\<not>  f))) =  sba (\<not>  (sda (\<not>  f)))" using "1" "2" "3" by fastforce
 from 4 show ?thesis by (metis sba_d_def)
qed

lemma SBaLeftSChopImpSChop:
 "\<turnstile>    sba (f\<longrightarrow> f1) \<longrightarrow> f\<frown> g \<longrightarrow> f1\<frown> g"
proof -
 have 1: "\<turnstile>  sba (f \<longrightarrow> f1) \<longrightarrow> bf (f \<longrightarrow> f1)" by (rule SBaImpBf)  
 have 2: "\<turnstile> bf (f \<longrightarrow> f1) \<longrightarrow> f\<frown> g \<longrightarrow> f1\<frown> g" by (rule BfSChopImpSChop)  
 from 1 2 show ?thesis by fastforce
qed

lemma BaLeftSChopImpSChop:
 "\<turnstile>    ba (f\<longrightarrow> f1) \<longrightarrow> f\<frown> g \<longrightarrow> f1\<frown> g"
proof -
 have 1: "\<turnstile>  ba (f \<longrightarrow> f1) \<longrightarrow> bf (f \<longrightarrow> f1)" by (rule BaImpBf)  
 have 2: "\<turnstile> bf (f \<longrightarrow> f1) \<longrightarrow> f\<frown> g \<longrightarrow> f1\<frown> g" by (rule BfSChopImpSChop)  
 from 1 2 show ?thesis by fastforce
qed

lemma SBaRightSChopImpSChop: 
 "\<turnstile>    sba (g\<longrightarrow> g1) \<and> finite \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> g1"
proof -
 have 1: "\<turnstile>  sba (g \<longrightarrow> g1) \<and> finite \<longrightarrow> \<box>(g \<longrightarrow> g1)" by (rule SBaImpBt)  
 have 2: "\<turnstile> \<box>(g \<longrightarrow> g1) \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> g1" by (rule BoxSChopImpSChop)  
 from 1 2 show ?thesis by fastforce
qed

lemma BaRightSChopImpSChop: 
 "\<turnstile>    ba (g\<longrightarrow> g1) \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> g1"
proof -
 have 1: "\<turnstile>  ba (g \<longrightarrow> g1) \<longrightarrow> \<box>(g \<longrightarrow> g1)" by (rule BaImpBt)  
 have 2: "\<turnstile> \<box>(g \<longrightarrow> g1) \<longrightarrow> f\<frown> g \<longrightarrow> f\<frown> g1" by (rule BoxSChopImpSChop)  
 from 1 2 show ?thesis by fastforce
qed

lemma SChopAndSBaImport:
  "\<turnstile>   (f\<frown> f1) \<and>  sba  g \<and> finite \<longrightarrow> (f \<and> g)\<frown> (f1 \<and> g)"
proof -
 have 1: "\<turnstile>  sba  g \<and> finite \<and> (f\<frown> f1) \<longrightarrow> (g \<and> f)\<frown> (g \<and> f1)" by (rule SBaAndSChopImport)  
 have 2: "\<turnstile> (g \<and> f)\<frown> (g \<and> f1) = (f \<and> g)\<frown> (f1 \<and> g)" by (rule AndSChopAndCommute) 
 from 1 2 show ?thesis by fastforce
qed

lemma SChopAndBaImport:
  "\<turnstile>   (f\<frown> f1) \<and>  ba  g  \<longrightarrow> (f \<and> g)\<frown> (f1 \<and> g)"
proof -
 have 1: "\<turnstile>  ba  g \<and> (f\<frown> f1) \<longrightarrow> (g \<and> f)\<frown> (g \<and> f1)" by (rule BaAndSChopImport)  
 have 2: "\<turnstile> (g \<and> f)\<frown> (g \<and> f1) = (f \<and> g)\<frown> (f1 \<and> g)" by (rule AndSChopAndCommute) 
 from 1 2 show ?thesis by fastforce
qed

lemma BaAndSChopImportA: 
 "\<turnstile> ba f \<and> g\<frown>g1 \<longrightarrow> (f \<and> g)\<frown>g1"
by (meson BaAndSChopImport SChopAndB lift_imp_trans)

lemma BaAndSChopImportB:
 "\<turnstile> ba f \<and> g\<frown>g1 \<longrightarrow> (f \<and> g)\<frown>(ba f \<and> g1)" 
proof -
 have 1: "\<turnstile> ba f = ba (ba f)" 
   by (simp add: BaEqvBaBa)
 have 2: "\<turnstile> ba (ba f) \<and> g\<frown>g1 \<longrightarrow> g\<frown>(ba f \<and> g1)"
   by (metis  AndSChopB BaAndSChopImport lift_imp_trans)
 have 3: "\<turnstile> ba f \<and> g\<frown>(ba f \<and> g1) \<longrightarrow> (f \<and> g)\<frown>(ba f \<and> g1)"
   by (simp add: BaAndSChopImportA)
 from 1 2 3 show ?thesis by fastforce
qed
 
lemma SBaImpSBaImpSBaAnd:
 "\<turnstile> sba h \<longrightarrow> sba(g \<longrightarrow> sba h \<and> g ) "
proof -
 have  1: "\<turnstile> sba h \<longrightarrow> (g \<longrightarrow> sba h \<and> g ) " by fastforce
 hence 2: "\<turnstile> sba(sba h) \<longrightarrow> sba(g \<longrightarrow> sba h \<and> g ) " by (rule SBaImpSBa)
 have  3: "\<turnstile> sba h = sba(sba h) " by (rule SBaEqvSBaSBa)
 from 2 3 show ?thesis by fastforce
qed

lemma SBaSChopImpSChopSBa:
 "\<turnstile>    sba  f \<and> finite \<longrightarrow> g\<frown> g1 \<longrightarrow> g\<frown> (( sba  f) \<and> g1)"
proof - 
 have 1: "\<turnstile>  sba  f \<longrightarrow>  sba (g1 \<longrightarrow> (sba f) \<and> g1 )" 
   by (rule SBaImpSBaImpSBaAnd)
 have 2: "\<turnstile>  sba (g1 \<longrightarrow>  sba  f \<and> g1 ) \<and> finite \<longrightarrow> g\<frown> g1 \<longrightarrow> g\<frown> ( sba  f \<and> g1)" 
   by (rule SBaRightSChopImpSChop)  
 from 1 2 show ?thesis by fastforce
qed

lemma BaSChopImpSChopBa:
 "\<turnstile>    ba  f  \<longrightarrow> g\<frown> g1 \<longrightarrow> g\<frown> (( ba  f) \<and> g1)"
proof - 
 have 1: "\<turnstile>  ba  f \<longrightarrow>  ba (g1 \<longrightarrow> (ba f) \<and> g1 )" 
   by (rule BaImpBaImpBaAnd)
 have 2: "\<turnstile>  ba (g1 \<longrightarrow>  ba  f \<and> g1 )  \<longrightarrow> g\<frown> g1 \<longrightarrow> g\<frown> ( ba  f \<and> g1)" 
   by (rule BaRightSChopImpSChop)  
 from 1 2 show ?thesis by fastforce
qed

lemma DfNotSBaImpNotSBa:
  "\<turnstile>   df (\<not> ( sba  f)) \<longrightarrow> \<not> ( sba  f)" 
proof -
 have  1: "\<turnstile>  sba  f =  sba(  sba  f)" by (rule SBaEqvSBaSBa)  
 have  2: "\<turnstile>  sba ( sba  f) \<longrightarrow> bf ( sba  f)" by (rule SBaImpBf)  
 have  3: "\<turnstile>  sba  f \<longrightarrow> bf ( sba  f)" using "1" "2" by fastforce
 hence 4: "\<turnstile>  sba  f \<longrightarrow> \<not> ( df (\<not> ( sba  f)))" by (simp add: bf_d_def)    
 from 4 show ?thesis by fastforce
qed

lemma DfNotBaImpNotBa:
  "\<turnstile>   df (\<not> ( ba  f)) \<longrightarrow> \<not> ( ba  f)" 
proof -
 have  1: "\<turnstile>  ba  f =  ba(  ba  f)" by (rule BaEqvBaBa)  
 have  2: "\<turnstile>  ba ( ba  f) \<longrightarrow> bf ( ba  f)" by (rule BaImpBf)  
 have  3: "\<turnstile>  ba  f \<longrightarrow> bf ( ba  f)" using "1" "2" by fastforce
 hence 4: "\<turnstile>  ba  f \<longrightarrow> \<not> ( df (\<not> ( ba  f)))" by (simp add: bf_d_def)    
 from 4 show ?thesis by fastforce
qed

lemma NotSBaSChopImpNotSBa:
 "\<turnstile>   (\<not> ( sba  f))\<frown> g \<longrightarrow> \<not> ( sba  f)"
proof -
 have 1: "\<turnstile> (\<not> ( sba  f))\<frown> g \<longrightarrow>  df (\<not> ( sba  f))" by (rule SChopImpDf)  
 have 2: "\<turnstile>  df (\<not> ( sba  f)) \<longrightarrow> \<not> ( sba  f)"  by (rule DfNotSBaImpNotSBa) 
 from 1 2 show ?thesis using lift_imp_trans by blast  
qed

lemma NotBaSChopImpNotSBa:
 "\<turnstile>   (\<not> ( ba  f))\<frown> g \<longrightarrow> \<not> ( ba  f)"
proof -
 have 1: "\<turnstile> (\<not> ( ba  f))\<frown> g \<longrightarrow>  df (\<not> ( ba  f))" by (rule SChopImpDf)  
 have 2: "\<turnstile>  df (\<not> ( ba  f)) \<longrightarrow> \<not> ( ba  f)"  by (rule DfNotBaImpNotBa) 
 from 1 2 show ?thesis using lift_imp_trans by blast  
qed

lemma DiamondSFinImpSFin:
 " \<turnstile> \<diamond> (sfin f) \<longrightarrow> sfin f"
proof -
 have  1: "\<turnstile> sfin f = #True\<frown>(f \<and> empty)" 
   by (rule SFinEqvTrueSChopAndEmpty)
 hence 2: "\<turnstile> \<diamond> (sfin f) = #True\<frown>(#True\<frown>(f \<and> empty)) "
   by (metis DiamondSChopdef inteq_reflection) 
 have  3: "\<turnstile> #True\<frown>(#True\<frown>(f \<and> empty)) = (#True\<frown>#True)\<frown>(f \<and> empty)" 
   by (rule SChopAssoc)
 have  4: "\<turnstile> (#True\<frown>#True)\<frown>(f \<and> empty) \<longrightarrow> #True\<frown>(f \<and> empty)" 
   using "1" "2" "3" 
   by (metis SChopImpDiamond TrueEqvTrueSChopTrue inteq_reflection)
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma SChopSFinImpSFin:
 " \<turnstile>   f \<frown> sfin  (init w) \<longrightarrow>  sfin  (init w)"
proof -
 have 1: "\<turnstile> f \<frown> sfin  (init w) \<longrightarrow> \<diamond> ( sfin  (init w))"  by (rule  SChopImpDiamond) 
 have 2: "\<turnstile> \<diamond>  (sfin  (init w)) \<longrightarrow>  sfin  (init w)" by (rule DiamondSFinImpSFin)
 from  1 2  show ?thesis using lift_imp_trans by blast   
qed

lemma SFinImpSYieldsSFin:
 "\<turnstile>    sfin  (init w)  \<longrightarrow> f syields (sfin  (init w))"
proof -
 have  1: "\<turnstile> f\<frown>  (sfin   (init (\<not> w)) ) \<longrightarrow>  (sfin   (init (\<not> w)) )" 
   by (simp add: SChopSFinImpSFin)
 have  2: "\<turnstile> finite \<longrightarrow> (\<not> ( sfin (init w)) ) = (sfin   (init (\<not> w)))     " 
   using SFinNotStateEqvNotSFinState by fastforce
 hence 3: "\<turnstile>  finite \<longrightarrow> f \<frown> (\<not> ( sfin (init w))) = f\<frown> ( sfin   (init (\<not> w)))"  
   using FiniteRightSChopEqvSChop by blast
 have  4: "\<turnstile> f\<frown> (\<not> ( sfin  (init w))) \<and> finite \<longrightarrow> (\<not> ( sfin  (init w)))" 
   using "1" "2" "3" by fastforce
 hence 5: "\<turnstile>  sfin  (init w) \<longrightarrow> \<not> (f\<frown> (\<not> ( sfin  (init w))))"
   by (metis (no_types, lifting) DiamondFin SChopImpDiamond int_simps(32) int_simps(4) 
       inteq_reflection sfin_d_def) 
 from 5 show ?thesis by (simp add: syields_d_def)
qed

lemma SChopAndSFin:
 " \<turnstile>  ((f\<frown> g) \<and>  (sfin  (init w))) = f\<frown> (g \<and>  (sfin  (init w)))"
proof -
 have  1: "\<turnstile>  sfin  (init w) \<longrightarrow> f syields ( sfin  (init w))" 
   by (rule SFinImpSYieldsSFin)  
 have 2: "\<turnstile> (f\<frown> g) \<and>  (sfin  (init w)) \<longrightarrow> (f\<frown> g ) \<and> f syields  ( sfin  (init w))" 
   using 1  by fastforce  
 have  3: "\<turnstile> f\<frown> g \<and> f syields  ( sfin  (init w)) \<longrightarrow>
              f\<frown> (g \<and>  (sfin  (init w) ))" 
   using SChopAndSYieldsImp by blast
 have  4: "\<turnstile> (f\<frown> g) \<and>  (sfin  (init w))\<longrightarrow> f\<frown> (g \<and>  sfin  (init w))" 
   using "2" "3" by (metis (mono_tags, lifting)  lift_imp_trans)
 from  4  show ?thesis 
   by (simp add: Prop12 SChopAndA SChopSFinExportA int_iffI)
qed

lemma SChopAndNotSFin:
  " \<turnstile>   (f\<frown> g \<and> \<not> ( sfin  (init w)) \<and> finite) = f\<frown> (g \<and> \<not> ( sfin  (init w)) \<and> finite)"
proof -
 have  1: "\<turnstile> (f\<frown> g \<and>  sfin   (init (\<not> w))) = f\<frown> (g \<and>  sfin   (init (\<not> w)))" 
   by (rule SChopAndSFin)  
 have  2: "\<turnstile>  (sfin   (init (\<not> w)) \<and> finite )= ( (\<not>  ( sfin  (init w) )) \<and> finite)"   
   using SFinNotStateEqvNotSFinState by fastforce
 hence 3: "\<turnstile> (g \<and>  sfin   (init (\<not> w))) = (g \<and> \<not>(  sfin  (init w)) \<and> finite)" 
   using DiamondEmptyEqvFinite SChopAndB SFinEqvTrueSChopAndEmpty TrueSChopEqvDiamond 
   by fastforce
 hence 4: "\<turnstile> f\<frown> (g \<and>  sfin    (init (\<not> w)) ) = f \<frown> (g \<and> \<not> ( sfin  (init w)) \<and> finite)" 
   using RightSChopEqvSChop by blast
 from 1 2 4 show ?thesis
   by (metis DiamondEmptyEqvFinite Prop10 SChopAndB SFinEqvTrueSChopAndEmpty TrueSChopEqvDiamond 
       inteq_reflection)
qed

lemma SFinSChopChain:
 "\<turnstile>   (((init w )  \<and> finite \<longrightarrow>  sfin  (init w1)))\<frown> 
      (((init w1)  \<and> finite \<longrightarrow>  sfin  (init w2)))
     \<and> finite
  \<longrightarrow> (((init w )  \<and> finite \<longrightarrow>  sfin  (init w2)))"
proof -
 have 01: "\<turnstile> (init w \<and> finite \<and> 
              ((init w \<and> finite \<longrightarrow> sfin (init w1)) \<and> finite);(init w1 \<and> finite \<longrightarrow> sfin (init w2))) = 
            (init w \<and> empty) \<frown> (((init w \<and> finite \<longrightarrow> sfin (init w1)) \<and> finite);
                                  (init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<and> finite)"
   by (meson Prop04 SChopAndCommute StateAndEmptySChop) 
 have 02: "\<turnstile> (finite \<and> init w) = (init w \<and> empty) \<frown> finite"
   by (metis StateAndEmptySChop inteq_reflection lift_and_com)   
 have 03: "\<turnstile> init w \<and> finite \<and> 
             ((init w \<and> finite \<longrightarrow> sfin (init w1)) \<and> finite);
             (init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<longrightarrow> finite \<and> init w "
   by force
 have 04: "\<turnstile>(init w \<and> finite \<and> (init w \<and> finite \<longrightarrow> sfin (init w1)));
            (init w1 \<and> finite \<longrightarrow> sfin (init w2)) = 
            (init w \<and> (finite \<and> (init w \<and> finite \<longrightarrow> sfin (init w1)));
                      (init w1 \<and> finite \<longrightarrow> sfin (init w2)))"
   by (simp add: StateAndChop)
 have 05: "\<turnstile> init w \<and> finite \<and> ((init w \<and> finite \<longrightarrow> sfin (init w1)) \<and> finite);
                                (init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<longrightarrow> 
              (init w \<and> finite \<and> (init w \<and> finite \<longrightarrow> sfin (init w1)));
              (init w1 \<and> finite \<longrightarrow> sfin (init w2))"
   by (metis "04" AndChopCommute ChopAndB StateAndEmptyChop int_eq)
 have 06: "\<turnstile> init w \<and> finite \<and> ((init w \<and> finite \<longrightarrow> sfin (init w1)) \<and> finite);
                                (init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<longrightarrow> 
                   (init w \<and> finite \<and> (init w \<and> finite \<longrightarrow> sfin (init w1)));
                   (init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<and> finite"
   by (meson "03" "05" Prop12)
 have  1: "\<turnstile>  (init w) \<and> finite \<and>
              ((init w) \<and> finite \<longrightarrow>  sfin  (init w1))\<frown> 
              ((init w1) \<and> finite \<longrightarrow>  sfin  (init w2))
           \<longrightarrow>   
              ((init w) \<and> finite \<and>  ((init w) \<and> finite \<longrightarrow> sfin  (init w1)))\<frown> 
              (((init w1) \<and> finite\<longrightarrow>  sfin  (init w2)) \<and> finite)"
   unfolding schop_d_def using "06" ChopAndFiniteDist by fastforce            
 have  2: "\<turnstile> (init w) \<and> finite \<and> ((init w) \<and> finite\<longrightarrow>  sfin  (init w1)) \<longrightarrow>  
              sfin  (init w1) " 
   by auto
 have  3: "\<turnstile> ((init w) \<and> finite \<and> ((init w) \<and> finite \<longrightarrow>  sfin  (init w1)))\<frown> 
             (((init w1) \<and> finite \<longrightarrow>  sfin  (init w2)) \<and> finite)
           \<longrightarrow>  
           ( sfin  (init w1))\<frown> (((init w1) \<and> finite \<longrightarrow>  sfin  (init w2)) \<and> finite)" 
   using  "2" LeftSChopImpSChop by blast
 have  4: "\<turnstile>  ( sfin  (init w1))\<frown> (((init w1) \<and> finite \<longrightarrow>  sfin  (init w2))) =
            \<diamond>((init w1)  \<and> ((init w1) \<and> finite \<longrightarrow>  sfin  (init w2)))" 
   using SFinSChopEqvDiamond by blast
 have 41: "\<turnstile> ((init w1) \<and> finite \<and> ((init w1) \<and> finite \<longrightarrow>  sfin (init w2))) \<longrightarrow> sfin (init w2)" 
   by auto
 have 42: "\<turnstile> \<diamond>((init w1) \<and> finite \<and>((init w1) \<and> finite \<longrightarrow> sfin (init w2))) \<longrightarrow> \<diamond>(sfin(init w2))" 
   using "41" DiamondImpDiamond   by blast
 have  5: "\<turnstile> \<diamond>( sfin( init w2)) \<longrightarrow>  sfin  (init w2)" 
   using DiamondSFinImpSFin by blast
 have 51: "\<turnstile> \<diamond>(init w1 \<and> finite \<and> (init w1 \<and> finite \<longrightarrow> sfin (init w2))) \<longrightarrow> sfin (init w2)"
   using "42" "5" lift_imp_trans by blast
 have 52: "\<turnstile> init w \<and> finite \<and> (init w \<and> finite \<longrightarrow> sfin (init w1)) \<frown> (init w1 \<and> finite \<longrightarrow> sfin (init w2))
               \<longrightarrow> sfin (init w1) \<frown> ((init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<and> finite)"
   by (meson "1" "3" lift_imp_trans)
 have 53: "\<turnstile> init w \<and> finite \<and> (init w \<and> finite \<longrightarrow> sfin (init w1)) \<frown> (init w1 \<and> finite \<longrightarrow> sfin (init w2))
            \<longrightarrow> \<diamond>(init w1 \<and> (init w1 \<and> finite \<longrightarrow> sfin (init w2)) \<and> finite)"
   by (metis "52" SFinSChopEqvDiamond inteq_reflection) 
 have  6: "\<turnstile> (init w) \<and> finite \<and> ((init w) \<and> finite \<longrightarrow>  sfin  (init w1))\<frown> 
             ((init w1) \<and> finite \<longrightarrow>  sfin  (init w2))
               \<longrightarrow>  sfin  (init w2)"
   by (metis "42" "5" "53" inteq_reflection lift_and_com lift_imp_trans)       
 from 6 show ?thesis by fastforce
qed

lemma SChopRule:
 assumes "\<turnstile>   (init w) \<and> f \<and> finite \<longrightarrow>  sfin  (init w1)"  
         "\<turnstile>   (init w1)\<and> f1 \<and> finite \<longrightarrow>  sfin  (init w2)"  
 shows   "\<turnstile>   (init w) \<and> (f\<frown> f1) \<and> finite \<longrightarrow>  sfin  (init w2)"
proof -
 have  1: "\<turnstile> (init w) \<and> (f\<frown> f1) \<and> finite \<longrightarrow> ((init w) \<and> f)\<frown> (f1 \<and> finite)"
   by (metis ChopEmpty SChopAssoc StateAndSChopImport inteq_reflection schop_d_def)
 have  2: "\<turnstile> (init w) \<and> f \<and> finite \<longrightarrow>  sfin  (init w1)" 
   using assms by auto
 have 21: "\<turnstile> (init w \<and> f \<and> finite);(f1 \<and> finite) = ((init w \<and> f);f1 \<and> finite)"
   by (metis ChopAndFiniteDist StateAndChop StateAndSChop inteq_reflection schop_d_def) 
 have 22: "\<turnstile> (init w \<and> f \<and> finite) = ((init w \<and> f \<and> finite) \<and> sfin (init w1))"
   using "2" Prop10 by blast   
 hence 3: "\<turnstile> ((init w) \<and> f)\<frown> (f1 \<and> finite) \<longrightarrow> ( sfin  (init w1))\<frown> (f1 \<and> finite)"
   using 21 22 
   by (metis (no_types, opaque_lifting) "2" ChopEmpty EmptySChop SChopAssoc StateAndSChop 
       StateAndSChopImpSChopRule int_eq schop_d_def)
 have  4: "\<turnstile> ( sfin  (init w1))\<frown> (f1 \<and> finite) =  \<diamond>((init w1) \<and> f1 \<and> finite)" 
   by (rule SFinSChopEqvDiamond)  
 have  5: "\<turnstile> (init w1) \<and> f1 \<and> finite \<longrightarrow>  sfin  (init w2)" 
   using assms by auto  
 hence 6: "\<turnstile> \<diamond>((init w1) \<and> f1 \<and> finite) \<longrightarrow> \<diamond> (sfin  (init w2))" 
   by (rule DiamondImpDiamond)  
 have  7: "\<turnstile> \<diamond>( sfin  (init w2)) \<longrightarrow>  sfin  (init w2)"  
   using DiamondSFinImpSFin by blast
 from 1 3 4 6 7 show ?thesis by fastforce
qed

lemma SChopRep:
 assumes "\<turnstile>  (init w) \<and> f \<and> finite \<longrightarrow> f1 \<and>  sfin  (init w1)"  
         "\<turnstile>   (init w1) \<and> g \<and> finite \<longrightarrow> g1"  
 shows   "\<turnstile>   (init w) \<and> ((f\<frown> g) \<and> finite) \<longrightarrow> (f1\<frown> g1)"
proof -
 have  1: "\<turnstile> (init w) \<and> f \<and> finite \<longrightarrow> (f1 \<and>  sfin  (init w1))" 
   using assms by auto  
 hence 2: "\<turnstile> (init w) \<and> (f\<frown> (g \<and> finite))  \<longrightarrow> (f1 \<and>  sfin  (init w1))\<frown> (g \<and> finite)" 
   by (metis DiamondEmptyEqvFinite FiniteAndEmptyEqvEmpty Prop12 SChopSFinExportA 
       SFinEqvTrueSChopAndEmpty StateAndChopImpChopRule StateAndEmptySChop 
       TrueSChopEqvDiamond inteq_reflection schop_d_def)
 have  3: "\<turnstile> (f1  \<and>  sfin  (init w1))\<frown> (g \<and> finite) = f1\<frown> ((init w1) \<and> (g \<and> finite))" 
   using AndSFinSChopEqvStateAndSChop   by blast
 have 31: "\<turnstile>  (init w) \<and> ((f\<frown> g) \<and> finite) \<longrightarrow> f1\<frown> ((init w1) \<and> (g \<and> finite))"
   using 2 3 by (metis ChopEmpty SChopAssoc inteq_reflection schop_d_def)
 have  4: "\<turnstile> (init w1)\<and> (g \<and> finite) \<longrightarrow> g1" 
   using assms by auto   
 hence 5: "\<turnstile> f1\<frown> ((init w1) \<and> (g \<and> finite)) \<longrightarrow> f1\<frown> g1" 
   using RightSChopImpSChop by blast
 show ?thesis using 31 5 by fastforce
qed

lemma SChopRepAndSFin:
 assumes "\<turnstile>   (init w) \<and> f \<and> finite \<longrightarrow> f1 \<and>  sfin  (init w1)"  
         "\<turnstile>   (init w1) \<and> g \<and> finite \<longrightarrow> g1 \<and>  sfin  (init w2)"  
 shows   "\<turnstile>   (init w) \<and> (f\<frown> g) \<and> finite \<longrightarrow> (f1\<frown> g1) \<and>  sfin  (init w2)"
proof -
 have  1: "\<turnstile> (init w) \<and> f \<and> finite \<longrightarrow> f1 \<and>  sfin  (init w1)" 
   using assms by auto  
 have  2: "\<turnstile> (init w1) \<and> g \<and> finite \<longrightarrow> g1 \<and>  sfin  (init w2)" 
   using assms by auto   
 have  3: "\<turnstile> (init w) \<and> (f\<frown> g) \<and> finite \<longrightarrow> f1\<frown> (g1 \<and>  sfin  (init w2))" 
   using "1" "2" by (rule SChopRep)  
 have  4: "\<turnstile> f1\<frown> (g1 \<and>  sfin  (init w2)) \<longrightarrow> f1\<frown> g1" 
   by (rule SChopAndA)  
 have  5: "\<turnstile> f1\<frown> (g1 \<and>  sfin  (init w2)) \<longrightarrow> f1\<frown>  sfin  (init w2)" 
   by (rule SChopAndB)  
 have  6: "\<turnstile> f1\<frown>  sfin  (init w2) \<longrightarrow>  sfin  (init w2)" 
   by (rule SChopSFinImpSFin)  
 show ?thesis
   by (metis "3" "4" "5" "6" Prop12 lift_imp_trans) 
qed

lemma TrueSChopMoreEqvMore:
 "\<turnstile> #True \<frown> more = more"
by (metis ChopAssoc TrueChopMoreEqvMore TrueEqvTrueSChopTrue inteq_reflection schop_d_def)

lemma SChopFmoreEqvFmore:
 "\<turnstile> #True\<frown>fmore = fmore"
by (simp add: FiniteChopFmoreEqvFmore schop_d_def)

lemma MoreSChopLoop:
 assumes "\<turnstile>   f \<longrightarrow>  more \<frown> f"
 shows   "\<turnstile> finite \<longrightarrow> \<not>  f"
proof -
 have   1: "\<turnstile> f \<longrightarrow>  more \<frown> f" 
   using assms by auto 
 hence 11: "\<turnstile> \<diamond> (f) \<longrightarrow> \<diamond> (more\<frown>f)" 
   using DiamondImpDiamond by blast
 have  12: "\<turnstile> \<diamond> (more\<frown>f) = #True\<frown>(more\<frown>f)" 
   by (simp add: DiamondSChopdef)
 have  13: "\<turnstile> #True\<frown>(more\<frown>f) = (#True\<frown>more)\<frown>f" 
   by (rule SChopAssoc)
 have  14: "\<turnstile>  \<diamond> (more\<frown>f) = more\<frown>f" 
   using "12" "13"  by (metis TrueSChopMoreEqvMore inteq_reflection)
 have   2: "\<turnstile>  more \<frown> f = \<circle>(\<diamond> f)" 
   using MoreSChopEqvNextDiamond by blast  
 have   3: "\<turnstile>  \<diamond> (f) \<longrightarrow> \<circle>(\<diamond> f)"  
   using "11" "14" "2" by fastforce
 hence  4: "\<turnstile> finite \<longrightarrow> \<not> (\<diamond> f)" 
   using NextLoop by blast
 have   5: "\<turnstile> \<not> (\<diamond> f) \<longrightarrow> \<not> f" 
   using NowImpDiamond by fastforce
 from 4 5 show ?thesis using lift_imp_trans by blast
qed

lemma MoreSChopContra:
 assumes "\<turnstile>   f \<and> \<not>  g \<longrightarrow> ( more \<frown> (f \<and> \<not>  g))"
 shows   "\<turnstile> f  \<and> finite \<longrightarrow> g "
proof -
 have  1: "\<turnstile> f \<and> \<not>  g \<longrightarrow> ( more \<frown> (f \<and> \<not>  g))" using assms by auto
 hence 2: "\<turnstile> finite \<longrightarrow> \<not> (f \<and> \<not>  g)" by (rule MoreSChopLoop)  
 from 2 show ?thesis by fastforce 
qed

lemma MoreSChopLoopFinite:
 assumes "\<turnstile>   f \<and> finite \<longrightarrow>  more \<frown> f"
 shows   "\<turnstile> finite \<longrightarrow> \<not>  f"
proof -
 have   1: "\<turnstile> f \<and> finite \<longrightarrow>  more \<frown> f" 
   using assms by auto 
 hence 11: "\<turnstile> \<diamond> (f \<and> finite) \<longrightarrow> \<diamond> (more\<frown>f)" 
   using DiamondImpDiamond by blast
 have  12: "\<turnstile> \<diamond> (more\<frown>f) = #True\<frown>(more\<frown>f)" 
   by (simp add: DiamondSChopdef)
 have  13: "\<turnstile> #True\<frown>(more\<frown>f) = (#True\<frown>more)\<frown>f" 
   by (rule SChopAssoc)
 have  14: "\<turnstile>  \<diamond> (more\<frown>f) = more\<frown>f" 
   using  "12" "13"  by (metis TrueSChopMoreEqvMore inteq_reflection)
 have   2: "\<turnstile>  more \<frown> f  = \<circle>(\<diamond> f)" 
   using MoreSChopEqvNextDiamond by blast  
 have   3: "\<turnstile>  \<diamond> (f \<and> finite)  \<longrightarrow> \<circle>(\<diamond> f)"  
   using "11" "14" "2" by fastforce
 have 31: "\<turnstile> \<diamond> (f \<and> finite) = ((\<diamond> f) \<and> finite)"
   by (metis (no_types, lifting) DiamondEmptyEqvFinite FiniteAndEmptyEqvEmpty SFinAndSChop 
       SFinEqvTrueSChopAndEmpty TrueSChopEqvDiamond inteq_reflection lift_and_com)
 have 32: "\<turnstile> (\<diamond> f) \<and> finite \<longrightarrow> \<circle>(\<diamond> f)"
   using "3" "31" by fastforce
 hence  4: "\<turnstile> finite \<longrightarrow> \<not> (\<diamond> f)" 
   by (metis (no_types, lifting) DiamondIntro FiniteChopInfEqvInf InfEqvNotFinite Prop09 
       finite_d_def int_simps(15) int_simps(32) inteq_reflection sometimes_d_def)
 have   5: "\<turnstile> \<not> (\<diamond> f) \<longrightarrow> \<not> f" 
   by (simp add: NowImpDiamond)
 from 4 5 show ?thesis using lift_imp_trans by fastforce
qed

lemma MoreSChopContraFinite:
 assumes "\<turnstile>   (f \<and> \<not>  g) \<and> finite \<longrightarrow> ( more \<frown> (f \<and> \<not>  g))"
 shows   "\<turnstile> f \<and> finite \<longrightarrow> g "
proof -
 have  1: "\<turnstile> (f \<and> \<not>  g) \<and> finite \<longrightarrow> ( more \<frown> (f \<and> \<not>  g))" using assms by auto
 hence 2: "\<turnstile> finite \<longrightarrow> \<not> (f \<and> \<not>  g)"  by (simp add: MoreSChopLoopFinite)
 from 2 show ?thesis by (simp add: Valid_def)
qed

lemma SChopLoop:
 assumes "\<turnstile>   f \<longrightarrow> g\<frown>f" 
         "\<turnstile> g \<longrightarrow>  fmore"
 shows   "\<turnstile> finite \<longrightarrow> \<not>  f"
proof -
have  1: "\<turnstile> f \<longrightarrow> g\<frown> f" using assms by auto  
have  2: "\<turnstile> g \<longrightarrow>  more" using assms by (simp add: Prop12 fmore_d_def) 
hence 3: "\<turnstile> g\<frown> f \<longrightarrow>  more \<frown> f" by (rule LeftSChopImpSChop)  
have  4: "\<turnstile> f \<longrightarrow>  more \<frown> f" using "1" "3" by fastforce 
from 4 show ?thesis using MoreSChopLoop by auto
qed

lemma SChopLoopB:
 assumes "\<turnstile>   f \<longrightarrow> g\<frown>f" 
         "\<turnstile> g \<longrightarrow>  more"
 shows   "\<turnstile> finite \<longrightarrow> \<not>  f"
proof -
have  1: "\<turnstile> f \<longrightarrow> g\<frown> f" using assms by auto  
have  2: "\<turnstile> g \<longrightarrow>  more" using assms by auto  
hence 3: "\<turnstile> g\<frown> f \<longrightarrow>  more \<frown> f" by (rule LeftSChopImpSChop)  
have  4: "\<turnstile> f \<longrightarrow>  more \<frown> f" using "1" "3" by fastforce 
from 4 show ?thesis using MoreSChopLoop by blast
qed

lemma SChopContra:
 assumes  "\<turnstile>   f \<and> \<not>  g \<longrightarrow> h\<frown> f \<and> \<not> (h\<frown> g)"
          "\<turnstile> h \<longrightarrow>  fmore" 
 shows    "\<turnstile> f  \<and> finite \<longrightarrow> g "
proof -
have  1: "\<turnstile> f \<and> \<not>  g \<longrightarrow> h\<frown> f \<and> \<not> (h\<frown> g)" using assms by auto  
have  2: "\<turnstile> h \<longrightarrow>  more" using assms  by (simp add: Prop12 fmore_d_def) 
have  3: "\<turnstile> h\<frown> f \<and> \<not> (h\<frown> g) \<longrightarrow> h\<frown> (f \<and> \<not>  g)" by (rule SChopAndNotSChopImp)  
have  4: "\<turnstile> h\<frown> (f \<and> \<not>  g) \<longrightarrow>  more \<frown> (f \<and> \<not>  g)" using "2" by (rule LeftSChopImpSChop)  
have  5: "\<turnstile> f \<and> \<not>  g \<longrightarrow>  more \<frown> (f \<and> \<not>  g)" using "1" "3" "4" by fastforce  
from 5 show ?thesis using MoreSChopContra by auto
qed

lemma SChopContraB:
 assumes  "\<turnstile> f \<and> \<not>  g \<longrightarrow> h\<frown> f \<and> \<not> (h\<frown> g)"
          "\<turnstile> h \<longrightarrow>  more" 
 shows    "\<turnstile> f \<and> finite \<longrightarrow> g "
proof -
have  1: "\<turnstile> f \<and> \<not>  g \<longrightarrow> h\<frown> f \<and> \<not> (h\<frown> g)" using assms by auto  
have  2: "\<turnstile> h \<longrightarrow>  more" using assms by auto   
have  3: "\<turnstile> h\<frown> f \<and> \<not> (h\<frown> g) \<longrightarrow> h\<frown> (f \<and> \<not>  g)" by (rule SChopAndNotSChopImp)  
have  4: "\<turnstile> h\<frown> (f \<and> \<not>  g) \<longrightarrow>  more \<frown> (f \<and> \<not>  g)" using "2" by (rule LeftSChopImpSChop)  
have  5: "\<turnstile> f \<and> \<not>  g \<longrightarrow>  more \<frown> (f \<and> \<not>  g)" using "1" "3" "4" by fastforce  
from 5 show ?thesis using MoreSChopContra by blast
qed



subsection \<open>Properties of Halt\<close>

lemma HaltSChopEqv:
 "\<turnstile>  ((halt ( init w)) \<frown> f) =  (if\<^sub>i  (init w)  then ( f ) else (\<circle>( (halt ( init w))\<frown> f))) "
proof -
 have  1: "\<turnstile>  halt(init w) =  
             (if\<^sub>i  (init w)  then   empty   else ( \<circle>( halt ( init w)))) " 
   by (rule HaltStateEqvIfStateThenEmptyElseNext)
 hence 2: "\<turnstile>  ((halt(init w))\<frown>f) =  
             (if\<^sub>i  (init w)  then   (empty\<frown>f)   else ( \<circle>( halt ( init w))\<frown>f)) " 
   by (rule IfSChopEqvRule)
 have  3: "\<turnstile>  empty \<frown> f = f " 
   by (rule EmptySChop)
 have  4: "\<turnstile> (\<circle> (halt ( init w)))\<frown> f = \<circle>( halt ( init w)\<frown> f)" 
   by (rule NextSChop)
 from 2 3 4 show ?thesis by (metis inteq_reflection)
qed

lemma AndHaltSChopImp:
 "\<turnstile>   init w \<and> ( halt ( init w)\<frown> f) \<longrightarrow> f "
proof -
 have 1: "\<turnstile> halt ( init w)\<frown> f =  if\<^sub>i  (init w)  then  f  else ( \<circle>( halt ( init w)\<frown> f)) " 
   by (rule HaltSChopEqv)
 have 2: "\<turnstile> init w \<and> if\<^sub>i  (init w)  then  f  else ( \<circle>( halt ( init w)\<frown> f)) \<longrightarrow> f" 
   by (auto simp: ifthenelse_d_def)
 from 1 2 show ?thesis by fastforce
qed
 
lemma NotAndHaltSChopImpNext:
 "\<turnstile>  \<not> ( init w) \<and> ( halt  (init w)\<frown> f) \<longrightarrow> \<circle>( halt ( init w)\<frown> f) "
proof -
 have 1: "\<turnstile>  halt ( init w)\<frown> f =  if\<^sub>i  (init w)  then  f  else ( \<circle>( halt ( init w)\<frown> f)) " 
   by (rule HaltSChopEqv)
 have 2: "\<turnstile> \<not> ( init w) \<and> if\<^sub>i  (init w)  then  f  else ( \<circle>( halt ( init w)\<frown> f)) \<longrightarrow> 
            \<circle>( halt ( init w)\<frown> f)"  
   by (auto simp: ifthenelse_d_def) 
 from 1 2 show ?thesis by fastforce
qed

lemma NotAndHaltSChopImpSkipSYields:
 "\<turnstile>  \<not> ( init w) \<and> ( halt ( init w)\<frown> f) \<longrightarrow>  skip  syields ( halt  (init w)\<frown> f) "
proof -
 have 1: "\<turnstile> \<not> ( init w) \<and> ( halt ( init w)\<frown> f) \<longrightarrow> \<circle>( halt ( init w)\<frown> f) " 
   by (rule NotAndHaltSChopImpNext)
 have 2: "\<turnstile> \<circle>( halt ( init w)\<frown> f) \<longrightarrow>  skip  syields ( halt ( init w)\<frown> f) " 
   by (rule NextImpSkipSYields)
 from 1 2 show ?thesis by fastforce
qed

lemma SChopAndEmptyEqvSChopAndEmpty:
 " \<turnstile> ((#True\<frown>(f \<and> empty)) \<and> g) = (g\<frown>(f\<and> empty))  "
proof -
 have 1: "\<turnstile> (#True\<frown>(f \<and> empty)) \<and> g \<longrightarrow> g \<frown>(f \<and> empty)"
   by (simp add: FiniteChopAndEmptyEqvChopAndEmpty int_iffD1 schop_d_def) 
 have 2: "\<turnstile> g\<frown>(f\<and> empty) \<longrightarrow> (#True\<frown>(f \<and> empty)) \<and> g"
   by (metis AndSFinEqvSChopAndEmpty Prop12 SFinEqvTrueSChopAndEmpty int_iffD1 inteq_reflection)
 from 1 2 show ?thesis by fastforce
qed

lemma NotSChopSkipEqvFmoreAndNotSChopSkip:
 "\<turnstile> (\<not> f)\<frown>skip = (fmore \<and> \<not>(f\<frown>skip))"
proof -
 have 1: "\<turnstile> (\<not> f)\<frown>skip = ((\<not>f \<and> finite);skip)"
   by (simp add: schop_d_def)
 have 2: "\<turnstile> (\<not>f \<and> finite);skip = (\<not>(f \<or> inf));skip"
   by (metis (no_types, lifting) LeftChopEqvChop finite_d_def int_simps(14) int_simps(33) 
       inteq_reflection)
 have 3: "\<turnstile> (\<not>(f \<or> inf));skip = (more \<and> \<not>((f \<or> inf);skip))"
   using NotChopSkipEqvMoreAndNotChopSkip by blast 
 have 4: "\<turnstile> (f \<or> inf);skip = (f;skip \<or> inf)"
   by (metis AndInfChopEqvAndInf MoreAndInfEqvInf OrChopEqv inteq_reflection)   
 have 5: "\<turnstile> (more \<and> \<not>((f \<or> inf);skip)) = (more \<and> \<not>(f;skip \<or> inf))"
   using "4" by auto
 have 6: "\<turnstile> (more \<and> \<not>(f;skip \<or> inf)) = (more \<and> \<not>(f;skip) \<and> finite)"
   unfolding finite_d_def by fastforce 
 have 7: "\<turnstile> (more \<and> \<not>(f;skip) \<and> finite) = (more \<and> \<not>(f\<frown>skip \<or> (f \<and> inf)) \<and> finite)"
   by (metis ChopEmpty ChopSChopdef inteq_reflection)
 have 8: "\<turnstile> (more \<and> \<not>(f\<frown>skip \<or> (f \<and> inf)) \<and> finite) =
            (more \<and> \<not>(f\<frown>skip) \<and> \<not>(f \<and> inf) \<and> finite)"
   by auto
 have 9: "\<turnstile> (\<not>(f \<and> inf) \<and> finite) = finite"
   unfolding finite_d_def by force 
 have 10: "\<turnstile> (more \<and> \<not>(f\<frown>skip) \<and> \<not>(f \<and> inf) \<and> finite) =
            (more \<and> \<not>(f\<frown>skip) \<and> finite)"
   using "9" by fastforce
 have 11: "\<turnstile> (more \<and> \<not>(f\<frown>skip) \<and> finite) = (fmore \<and> \<not>(f\<frown>skip))"
   using fmore_d_def by (metis Prop11 Prop12 lift_and_com) 
 from 1 2 3 5 6 7 8 10 11 show ?thesis by (metis inteq_reflection)
qed

lemma HaltSChopImpNotHaltSChopNot:
 "\<turnstile>    halt ( init w)\<frown> f \<and> finite \<longrightarrow> \<not> ( halt ( init w)\<frown> (\<not>  f)) "
proof -
 have   1: "\<turnstile>  halt  (init w)\<frown> f =  if\<^sub>i  (init w)  then  f  else ( \<circle>( halt ( init w)\<frown> f)) " 
   by (rule HaltSChopEqv)
 have   2: "\<turnstile> if\<^sub>i  (init w)  then  f  else ( \<circle>( halt ( init w)\<frown> f)) \<longrightarrow> 
              ( ((init w) \<longrightarrow> f) \<and> ( \<not>(init w) \<longrightarrow> ( \<circle>( halt ( init w)\<frown> f))))"  
   by (rule IfThenElseImp) 
 have   3: "\<turnstile>  halt  (init w)\<frown> (\<not>f) =  
               if\<^sub>i  (init w)  then  (\<not>f)  else ( \<circle>( halt ( init w)\<frown> (\<not>f))) " 
   by (rule HaltSChopEqv)
 have   4: "\<turnstile> if\<^sub>i  (init w)  then  (\<not>f)  else ( \<circle>( halt ( init w)\<frown> (\<not>f))) \<longrightarrow> 
              ( ((init w) \<longrightarrow> \<not>f) \<and> ( \<not>(init w) \<longrightarrow> ( \<circle>( halt ( init w)\<frown> (\<not>f)))))"  
   by (rule IfThenElseImp)
 have   5: "\<turnstile> halt  (init w)\<frown> f \<and> halt  (init w)\<frown> (\<not>f) \<longrightarrow>
            ( ((init w) \<longrightarrow> f) \<and> ( \<not>(init w) \<longrightarrow> ( \<circle>( halt ( init w)\<frown> f)))) \<and>
            ( ((init w) \<longrightarrow> \<not>f) \<and> ( \<not>(init w) \<longrightarrow> ( \<circle>( halt ( init w)\<frown> (\<not>f))))) " 
   using "1" "2" "3" "4" by fastforce
 have   6: "\<turnstile> ( ((init w) \<longrightarrow> f) \<and> ( \<not>(init w) \<longrightarrow> ( \<circle>( halt ( init w)\<frown> f)))) \<and>
            ( ((init w) \<longrightarrow> \<not>f) \<and> ( \<not>(init w) \<longrightarrow> ( \<circle>( halt ( init w)\<frown> (\<not>f))))) \<longrightarrow>
            ( \<circle>( halt ( init w)\<frown> f)) \<and> ( \<circle>( halt ( init w)\<frown> (\<not>f))) " 
   by auto
 have   7: "\<turnstile> halt  (init w)\<frown> f \<and> halt  (init w)\<frown> (\<not>f) \<longrightarrow>
            ( \<circle>( halt ( init w)\<frown> f)) \<and> ( \<circle>( halt ( init w)\<frown> (\<not>f))) " 
   using "5" "6" lift_imp_trans by blast
 have   8: "\<turnstile> (( \<circle>( halt ( init w)\<frown> f)) \<and> ( \<circle>( halt ( init w)\<frown> (\<not>f)))) =
             \<circle> (halt ( init w)\<frown> f \<and> halt ( init w)\<frown> (\<not>f)) " 
   using NextAndEqvNextAndNext by fastforce
 have   9: "\<turnstile> halt  (init w)\<frown> f \<and> halt  (init w)\<frown> (\<not>f) \<longrightarrow> 
              \<circle> (halt ( init w)\<frown> f \<and> halt ( init w)\<frown> (\<not>f)) " 
   using "7" "8" by fastforce
 hence 10: "\<turnstile> finite \<longrightarrow> \<not>(halt  (init w)\<frown> f \<and> halt  (init w)\<frown> (\<not>f)) " 
   using NextLoop by blast
 from 10 show ?thesis by auto
qed

lemma HaltSChopImpHaltSYields:
 "\<turnstile>    halt ( init w)\<frown> f \<and> finite \<longrightarrow> ( halt ( init w)) syields  f "
proof -
 have 1: "\<turnstile>  halt ( init w)\<frown> f \<and> finite \<longrightarrow> \<not> ( halt ( init w)\<frown> (\<not>  f)) " 
   by (rule HaltSChopImpNotHaltSChopNot)
 from 1 show ?thesis by (simp add: syields_d_def)
qed

lemma HaltSChopAnd:
 "\<turnstile> ( halt (init w))\<frown> f \<and> ( halt  (init w))\<frown> g \<and> finite\<longrightarrow> ( halt ( init w))\<frown> (f \<and> g) "
proof -
 have  1: "\<turnstile> ( halt (init w))\<frown> g \<and> finite \<longrightarrow> ( halt (init w))  syields  g " 
   by (rule HaltSChopImpHaltSYields)
 hence 2: "\<turnstile> ( halt  (init w))\<frown> f \<and> ( halt  (init w))\<frown> g \<and> finite \<longrightarrow>
             ( halt  (init w))\<frown> f \<and> ( halt  (init w)) syields  g " 
   by auto
 have  3: "\<turnstile> ( halt  (init w))\<frown> f \<and> ( halt  (init w)) syields  g\<longrightarrow>
             ( halt  (init w))\<frown> (f \<and> g) " 
   by (rule SChopAndSYieldsImp)
 from 2 3 show ?thesis by fastforce
qed

lemma HaltAndSChopAndHaltSChopImpHaltAndSChopAnd:
 "\<turnstile> ( halt  (init w) \<and> f)\<frown> f1 \<and> ( halt  (init w)\<frown> g) \<and> finite 
   \<longrightarrow> ( halt ( init w) \<and> f)\<frown> (f1 \<and> g) "
proof -
 have   1: "\<turnstile> f1 \<longrightarrow> \<not>  g \<or>  (f1 \<and> g) " 
   by auto
 hence  2: "\<turnstile> ( halt  (init w) \<and> f)\<frown> f1 \<longrightarrow>  
             ( halt  (init w) \<and> f)\<frown> (\<not>  g) \<or>  (( halt  (init w) \<and> f)\<frown> (f1 \<and> g)) " 
   by (rule SChopOrImpRule)
 have   3: "\<turnstile> ( halt  (init w) \<and> f)\<frown> (\<not>  g) \<longrightarrow>  halt  (init w)\<frown> (\<not>  g) " 
   by (rule AndSChopA)
 have  31: "\<turnstile> ( halt  (init w) \<and> f)\<frown> f1 \<longrightarrow> 
             halt  (init w)\<frown> (\<not>  g) \<or>  (( halt  (init w) \<and> f)\<frown> (f1 \<and> g)) " 
   using "2""3" by fastforce
 have   4: "\<turnstile>  halt  (init w)\<frown> g \<and> finite \<longrightarrow> \<not> ( halt  (init w)\<frown> (\<not>  g)) " 
   by (rule HaltSChopImpNotHaltSChopNot)
 hence 41: "\<turnstile> ( halt  (init w)\<frown> (\<not>  g)) \<and> finite \<longrightarrow> \<not>(halt  (init w)\<frown> g)" 
   by auto
 have  42: "\<turnstile> ( halt  (init w) \<and> f)\<frown> f1 \<and> finite \<longrightarrow> 
             \<not>( halt  (init w)\<frown> g) \<or>  (( halt  (init w) \<and> f)\<frown> (f1 \<and> g)) " 
   using "31" "41" by fastforce
 from 42 show ?thesis by auto
qed

lemma HaltImpBoxSYields:
 "\<turnstile>   ( halt  (init w))\<frown> f \<and> finite \<longrightarrow> (\<box>(\<not> ( init w)))  syields  (( halt  (init w))\<frown> f)"
proof -
 have   1: "\<turnstile> (\<box> (\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)) \<longrightarrow>  df  (\<box> (\<not>  (init w))) " 
   by (rule SChopImpDf)
 have   2: "\<turnstile> \<box> (\<not>  (init w)) \<longrightarrow> \<not>  (init w) " 
   by (rule BoxElim)
 hence  3: "\<turnstile>  df (\<box> (\<not>  (init w))) \<longrightarrow>  df (\<not>  (init w)) " 
   by (rule DfImpDf)
 have   4: "\<turnstile>  df   (init (\<not> w)) =   (init (\<not>w)) " 
   by (rule DfState)
 have  41: "\<turnstile>  (init (\<not> w)) =  (\<not> (init w))" 
   using Initprop(2) by fastforce
 have  42: "\<turnstile>  df  (\<not> (init  w)) =   (\<not>(init w)) " 
   using "4" "41" by (metis inteq_reflection)
 have   5: "\<turnstile> ((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f))) \<longrightarrow> \<not> ( init w) " 
   using "1" "2" "42" using "3" by fastforce
 hence 51: "\<turnstile> ( halt  (init w)\<frown> f) \<and> ((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f))) \<longrightarrow>
            ( halt  (init w)\<frown> f) \<and> \<not> ( init w) " 
   by fastforce
 have   6: "\<turnstile>  halt  (init w)\<frown> f = if\<^sub>i (init w)  then  f  else  (\<circle>( halt  (init w)\<frown> f)) " 
   by (rule HaltSChopEqv)
 hence 61: "\<turnstile> (halt  (init w)\<frown> f \<and> \<not> ( init w)) = 
              ((if\<^sub>i (init w)  then  f  else  (\<circle>( halt  (init w)\<frown> f))) \<and> \<not> ( init w)) " 
   using "6" by auto
 have  62: "\<turnstile> (if\<^sub>i (init w)  then  f  else  (\<circle>( halt  (init w)\<frown> f))) \<and> 
              \<not> ( init w) \<longrightarrow> (\<circle>( halt  (init w)\<frown> f)) "  
   by (auto simp: ifthenelse_d_def) 
 have  63: "\<turnstile> halt  (init w)\<frown> f \<and> \<not> ( init w) \<longrightarrow> (\<circle>( halt  (init w)\<frown> f))  " 
   using "61" "62" by fastforce
 have   7: "\<turnstile> ( halt  (init w)\<frown> f) \<and> (\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)) \<longrightarrow>
             \<circle>(( halt  (init w))\<frown> f) " 
   using "51" "63" using lift_imp_trans by blast
 have   8: "\<turnstile> \<box> (\<not> (init w)) \<longrightarrow>  empty  \<or>  \<circle>(\<box>(\<not>(  init w))) "
   by (metis BoxImpYields WeakNextBoxImpMoreYields WnextEqvEmptyOrNext fmore_d_def int_eq)  
 hence  9: "\<turnstile> ((\<box> (\<not> ( init w)))\<frown> (\<not> ( halt  (init w)\<frown> f))) \<longrightarrow>  
            \<not> ( halt  (init w)\<frown> f) \<or>  \<circle>((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f))) " 
   by (rule EmptyOrNextSChopImpRule)
 hence 10: "\<turnstile> (( halt  (init w))\<frown> f) \<and> (\<box> (\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)) \<longrightarrow>  
            \<circle>((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f))) " 
   by fastforce
 have  11: "\<turnstile> ( halt  (init w))\<frown> f \<and> (\<box> (\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)) \<longrightarrow> 
           \<circle>(( halt  (init w))\<frown> f) \<and> \<circle>((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f))) " 
   using "7" "10" by fastforce
 have  12: "\<turnstile> \<circle>(( halt  (init w))\<frown> f) \<and> \<circle>((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)))
           \<longrightarrow>  \<circle>((( halt (init w))\<frown> f) \<and> ((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)))) " 
   using NextAndEqvNextAndNext by fastforce
 have  13: "\<turnstile> ( halt  (init w))\<frown> f \<and> (\<box> (\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)) \<longrightarrow>  
             \<circle>((( halt  (init w))\<frown> f) \<and> ((\<box>(\<not>  (init w)))\<frown> (\<not> ( halt  (init w)\<frown> f)))) " 
   using "11" "12" by fastforce
 hence 14: "\<turnstile> finite \<longrightarrow> \<not> (( halt  (init w))\<frown> f \<and> (\<box> (\<not> (init w)))\<frown> (\<not>(halt (init w)\<frown> f))) " 
   using NextLoop by blast
 hence 15: "\<turnstile> ( halt  (init w))\<frown> f \<and> finite \<longrightarrow> \<not> ((\<box> (\<not> (init w)))\<frown> (\<not> ( halt (init w)\<frown> f))) " 
   by auto
 from 15 show ?thesis by (simp add: syields_d_def)
qed

subsection \<open>Properties of Groups of strong chops\<close>

lemma NestedSChopImpSChop:
 assumes "\<turnstile> init w  \<and> f  \<longrightarrow> g \<frown> (init w1 \<and> f1) "
         "\<turnstile> init w1 \<and> f1 \<longrightarrow> g1\<frown> (init w2 \<and> f2) "
 shows   "\<turnstile> init w  \<and> f  \<longrightarrow> g \<frown> (g1\<frown> (init w2 \<and> f2)) "
proof -
 have  1: "\<turnstile> init w \<and> f \<longrightarrow> g\<frown> (init w1 \<and> f1) " using assms(1) by auto
 have  2: "\<turnstile> init w1 \<and> f1 \<longrightarrow> g1\<frown> (init w2 \<and> f2) " using assms(2) by auto
 hence 3: "\<turnstile> g\<frown> (init w1 \<and> f1) \<longrightarrow> g\<frown> (g1\<frown> (init w2 \<and> f2)) " by (rule RightSChopImpSChop)
 from 1 3 show ?thesis by fastforce
qed
 



end


