(*  title     : An encoding of ITL in Isabelle/HOL
    Authors   : Antonio Cau     <cau.researcher at gmail.com>
                Ben Moszkowski
                David Smallwood <drs at dmu.ac.uk>
    Maintainer: Antonio Cau     <cau.researcher at gmail.com>        
    License   : BSD
*)
section  \<open>Axioms and Rules\<close>

theory ITL
imports
   Semantics
begin
                             


text \<open>
The Finite and Infinite ITL axiom and proof rules are introduced (taken from 
\cite{moszkowski12:_compl_axiom_system_propos_inter}).
The soundness of the rules and axioms are checked using the lemmas of Semantics.thy.
\<close>

subsection \<open>Rules\<close>

lemma MP :
 assumes "\<turnstile> f \<longrightarrow> g"
         "\<turnstile> f"
 shows   "\<turnstile> g"  
using assms by fastforce

lemma BoxGen :
 assumes "\<turnstile> f"
 shows   "\<turnstile> \<box> f"
using assms 
by (auto simp add: itl_defs Valid_def)
    
lemma BiGen:
 assumes "\<turnstile> f"
 shows   "\<turnstile> bi f"
using assms 
by (auto simp add: itl_defs Valid_def)

subsection \<open>Axioms\<close>
    
lemma ChopAssoc : 
    "\<turnstile>  f ; (g ; h) =  (f;g);h "
using  ChopAssocSem Valid_def by blast
 
lemma OrChopImp :
    "\<turnstile> ( f \<or> g);h   \<longrightarrow>  f;h \<or> g;h  "
using OrChopImpSem Valid_def by blast

lemma ChopOrImp :
    "\<turnstile>  f;(g \<or> h) \<longrightarrow>   f;g \<or>  f;h "
using ChopOrImpSem Valid_def by blast
      
lemma EmptyChop :
    "\<turnstile>  empty ; f = f  "
using EmptyChopSem Valid_def by blast

lemma ChopEmpty :
    "\<turnstile> f;empty = f  "
using ChopEmptySem Valid_def by blast

lemma StateImpBi :
    "\<turnstile> init f \<longrightarrow>   bi (init f)  "
using StateImpBiSem Valid_def by blast

lemma NextImpNotNextNot :
    "\<turnstile>  \<circle> f \<longrightarrow>  \<not> (\<circle> (\<not> f)) "
using NextImpNotNextNotSem Valid_def by blast

lemma BiBoxChopImpChop :
    "\<turnstile>  bi ( f \<longrightarrow> f1) \<and> \<box>(g \<longrightarrow> g1) \<longrightarrow> f;g \<longrightarrow> f1;g1 "
using BiBoxChopImpChopSem Valid_def by blast

lemma BoxInduct :
    "\<turnstile> \<box> (f \<longrightarrow> wnext f) \<and> f \<longrightarrow> \<box> f "
using BoxInductSem Valid_def by blast



subsection \<open>Additional Lemmas\<close>

text \<open>
 The following is again from \cite{Merz98,GrovMerz} but adapted for our need.
\<close>

lemma int_eq_true: 
assumes "\<turnstile> P "
 shows  "\<turnstile> P = #True"
using assms by auto

lemma int_eq: 
assumes "\<turnstile> X = Y"
  shows " X = Y"
using assms by (auto simp: inteq_reflection)

lemma int_iffI: 
  assumes "\<turnstile> F \<longrightarrow> G" and "\<turnstile> G \<longrightarrow> F"
  shows "\<turnstile> F = G"
using assms by force

lemma int_iffD1: assumes h: "\<turnstile> F = G" shows "\<turnstile> F \<longrightarrow> G"
using h by auto

lemma int_iffD2: assumes h: "\<turnstile> F = G" shows "\<turnstile> G \<longrightarrow> F"
using h by auto

lemma lift_imp_trans: 
  assumes "\<turnstile> A \<longrightarrow> B" and "\<turnstile> B \<longrightarrow> C"
  shows "\<turnstile> A \<longrightarrow> C"
using assms by force

lemma lift_imp_neg: assumes "\<turnstile> A \<longrightarrow> B" shows "\<turnstile> \<not>B \<longrightarrow> \<not>A"
using assms by auto

lemma lift_and_com:  "\<turnstile> (A \<and> B) = (B \<and> A)"
by auto

subsection \<open>Quantification\<close>

lemma EExI :
 "\<turnstile> F y \<longrightarrow> (\<exists>\<exists> x . F x)"
by (auto simp add: exist_state_d_def Valid_def) 


lemma EExE: 
assumes  "\<And>x. \<turnstile> F x \<longrightarrow> G"
shows    "\<turnstile> (\<exists>\<exists> x. F x) \<longrightarrow> G "
using assms by (metis (mono_tags, lifting) Valid_def exist_state_d_def unl_lift2)

lemma EExVal: 
  "(( w) \<Turnstile> (\<exists>\<exists> x. F x)) = 
   (\<exists> x (val :: 'a nellist). ( ( val = (nmap x w) \<and>  (( w) \<Turnstile> F x))))"
by (simp add: exist_state_d_def)

lemma AAxDef:
 "\<turnstile> (\<forall>\<forall> x. F x) = (\<not>(\<exists>\<exists> x. \<not>(F x)))"
by (simp add: Valid_def forall_state_d_def exist_state_d_def) 

lemma ExEqvRule:
assumes "\<And> x. \<turnstile> (f x) = (g x)"
  shows "\<turnstile> (\<exists> x. f x) = (\<exists> x. g x)"
using assms by fastforce
  

subsection \<open>Lemmas about \<open>current_val\<close>\<close>

lemma current_const: "\<turnstile> $(#c) = #c"
by (simp add: current_val_d_def intI)

lemma current_fun1: "\<turnstile> $(f<x>) = f <$x>"
by (simp add: current_val_d_def intI)

lemma current_fun2: "\<turnstile> $(f<x,y>) = f <$x,$y>"
by (auto simp: current_val_d_def intI)

lemma current_fun3: "\<turnstile> $(f<x,y,z>) = f <$x,$y,$z>"
by (auto simp: current_val_d_def intI)

lemma current_forall: "\<turnstile> $(\<forall> x. P x) = (\<forall> x. $(P x))"
by (auto simp: current_val_d_def intI)

lemma current_exists: "\<turnstile> $(\<exists> x. P x) = (\<exists> x. $(P x))"
by (auto simp: current_val_d_def intI)

lemma current_exists1: "\<turnstile> $(\<exists>! x. P x) = (\<exists>! x. $(P x))"
by (auto simp: current_val_d_def intI)

lemmas all_current = current_const current_fun1 current_fun2 current_fun3 
  current_forall current_exists current_exists1

lemmas all_current_unl = all_current[THEN intD]
lemmas all_current_eq = all_current[THEN inteq_reflection]


subsection \<open>Lemmas about \<open>next_val\<close>\<close>

lemma next_const: "\<turnstile> more \<longrightarrow> (#c)$ = #c"
by (auto simp: next_val_d_def more_defs zero_enat_def intI)

lemma next_fun1: "\<turnstile> more \<longrightarrow> f<x>$ = f<x$>"
by (auto simp: next_val_d_def more_defs zero_enat_def intI)

lemma next_fun2: "\<turnstile> more \<longrightarrow> f<x,y>$ = f <x$,y$>"
by (auto simp: next_val_d_def more_defs zero_enat_def intI)

lemma next_fun3: "\<turnstile> more \<longrightarrow> f<x,y,z>$ = f <x$,y$,z$>"
by (auto simp: next_val_d_def more_defs zero_enat_def intI)

lemma next_forall: "\<turnstile> more \<longrightarrow> (\<forall> x. P x)$ = (\<forall> x. (P x)$)"
by (auto simp: next_val_d_def intI)

lemma next_exists: "\<turnstile> more \<longrightarrow> (\<exists> x. P x)$ = (\<exists> x. (P x)$)"
by (auto simp: next_val_d_def intI)

lemma next_exists1: "\<turnstile> more \<longrightarrow> (\<exists>! x. P x)$ = (\<exists>! x. (P x)$)"
by (auto simp: next_val_d_def more_defs zero_enat_def intI)

lemmas all_next = next_const next_fun1 next_fun2 next_fun3 
  next_forall next_exists next_exists1 

lemmas all_next_unl = all_next[THEN intD]


subsection \<open>Lemmas about \<open>fin_val\<close>\<close>

lemma fin_const: "\<turnstile> finite \<longrightarrow> !(#c) = #c"
by (auto simp: fin_val_d_def finite_defs intI)

lemma fin_fun1: "\<turnstile> finite \<longrightarrow>!(f<x>) = f <!x>"
by (auto simp: fin_val_d_def finite_defs intI)

lemma fin_fun2: "\<turnstile> finite \<longrightarrow> !(f<x,y>) = f <!x, !y>"
by (auto simp: fin_val_d_def finite_defs intI)

lemma fin_fun3: "\<turnstile> finite \<longrightarrow> !(f<x,y,z>) = f <!x,!y,!z>"
by (auto simp: fin_val_d_def finite_defs intI)

lemma fin_forall: "\<turnstile> finite \<longrightarrow> !(\<forall> x. P x) = (\<forall> x. !(P x))"
by (auto simp: fin_val_d_def finite_defs intI)

lemma fin_exists: "\<turnstile> finite \<longrightarrow> !(\<exists> x. P x) = (\<exists> x. !(P x))"
by (auto simp: fin_val_d_def finite_defs intI)

lemma fin_exists1: "\<turnstile> finite \<longrightarrow> !(\<exists>! x. P x) = (\<exists>! x. !(P x))"
by (auto simp: fin_val_d_def finite_defs intI)

lemmas all_fin = fin_const fin_fun1 fin_fun2 fin_fun3 
  fin_forall fin_exists fin_exists1

lemmas all_fin_unl = all_fin[THEN intD]


subsection \<open>Lemmas about \<open>penult_val\<close>\<close>

lemma penult_const: "\<turnstile> more \<and> finite \<longrightarrow> (#c)! = #c"
by (auto simp: penult_val_d_def more_defs finite_defs zero_enat_def intI)



lemma penult_fun1: "\<turnstile> more \<and> finite \<longrightarrow> f<x>! = f<x!>"
by (auto simp: penult_val_d_def more_defs finite_defs zero_enat_def intI)

lemma penult_fun2: "\<turnstile> more \<and> finite \<longrightarrow> f<x,y>! = f <x!,y!>"
by (auto simp: penult_val_d_def more_defs finite_defs zero_enat_def intI)

lemma penult_fun3: "\<turnstile> more \<and> finite \<longrightarrow> f<x,y,z>! = f <x!,y!,z!>"
by (auto simp: penult_val_d_def more_defs finite_defs zero_enat_def intI)

lemma penult_forall: "\<turnstile> more \<and> finite \<longrightarrow> (\<forall> x. P x)! = (\<forall> x. (P x)!)"
by (auto simp: penult_val_d_def finite_defs intI)

lemma penult_exists: "\<turnstile> more \<and> finite \<longrightarrow> (\<exists> x. P x)! = (\<exists> x. (P x)!)"
by (auto simp: penult_val_d_def finite_defs intI)

lemma penult_exists1: "\<turnstile> more \<and> finite \<longrightarrow> (\<exists>! x. P x)! = (\<exists>! x. (P x)!)"
by (auto simp: penult_val_d_def more_defs finite_defs zero_enat_def intI)

lemmas all_penult = penult_const penult_fun1 penult_fun2 penult_fun3 
  penult_forall penult_exists penult_exists1 

lemmas all_penult_unl = all_penult[THEN intD]


subsection \<open>Basic temporal variables properties\<close>

lemma empty_imp_fin_eqv_curr:
 "\<turnstile> empty \<longrightarrow> !v = $v"
by (simp add: Valid_def itl_defs nlength_eq_enat_nfiniteD)
 (metis nlast_NNil nlength_eq_enat_nfiniteD nnth_nlast ntaken_0 ntaken_nlast the_enat_0 zero_enat_def)  



lemma skip_imp_fin_eqv_next:
 "\<turnstile> skip \<longrightarrow> !v = v$"
by (simp add: Valid_def itl_defs)
   (metis One_nat_def le_numeral_extra(4) ndropn_0 nlength_eq_enat_nfiniteD 
    ntaken_all ntaken_ndropn_nlast one_enat_def plus_1_eq_Suc)

lemma skip_imp_penult_eqv_curr:
 "\<turnstile> skip \<longrightarrow> v! = $v"
by (simp add: Valid_def itl_defs current_val_d_def nlength_eq_enat_nfiniteD)
   (metis ndropn_0 ndropn_nfirst) 

end