(*  title     : An encoding of ITL in Isabelle/HOL
    Authors   : Antonio Cau     <cau.researcher at gmail.com>
                Ben Moszkowski
                David Smallwood <drs at dmu.ac.uk>
    Maintainer: Antonio Cau     <cau.researcher at gmail.com>        
    License   : BSD
*)

section \<open>Quantifiers\<close>

theory FOTheorems
 imports
   SChopTheorems Chopstar
begin
(*
 sledgehammer_params [minimize=true,preplay_timeout=10,timeout=60,verbose=true,
                    provers="vampire cvc4 z3 e spass  " ]
*)


text \<open>
We give the proofs of a list of first order (in)finite ITL theorems. 
\<close>

lemma EExI_unl:
 "w \<Turnstile> f x \<Longrightarrow> w \<Turnstile> (\<exists>\<exists> x. f x) "
by (meson exist_state_d_def)


(*
lemmas EExI_unl = EExI[unlift_rule] \<comment> \<open>@{text "w \<Turnstile> F x \<Longrightarrow> w \<Turnstile> (\<exists>\<exists> x. F x)"}\<close>
*)

lemma EExNoDep:
 "\<turnstile> (\<exists>\<exists> x. g) = g"
proof -
  have 1: "\<turnstile> g \<longrightarrow> (\<exists>\<exists> x. g)" by (meson EExI)
  have 2: "\<And> x. \<turnstile> g \<longrightarrow> g" by simp
  have 3: "\<turnstile> (\<exists>\<exists> x. g) \<longrightarrow> g " using "2" by (meson EExE)
  from 1 3 show ?thesis using int_iffI by blast
qed

lemma AAxNoDep:
 "\<turnstile> (\<forall>\<forall> x. g) = g"
using EExNoDep[of "LIFT(\<not> g)"] AAxDef EExE EExI
by (simp add: exist_state_d_def forall_state_d_def intI)

lemma EExEqvRule:
 assumes "\<And> x. \<turnstile> f x = g x"
 shows   "\<turnstile> (\<exists>\<exists> x. f x) = (\<exists>\<exists> x. g x)"
by (metis EExE EExI assms int_iffD1 int_iffD2 int_iffI lift_imp_trans)
 
lemma AAxImpEEx:
 "\<turnstile> (\<forall>\<forall> x. f x) \<longrightarrow> (\<exists>\<exists> x. f x)"
by (simp add: exist_state_d_def forall_state_d_def intI)

lemma EExImpRule:
 assumes "\<turnstile> f x \<longrightarrow> g x"
 shows   "\<turnstile> (\<exists>\<exists> x. f x \<longrightarrow>  g x)  "
using assms by (meson MP EExI)

lemma EExImpRuleDist:
 assumes "\<turnstile> f x \<longrightarrow> g x"
 shows   "\<turnstile> (\<forall>\<forall> x. f x) \<longrightarrow> (\<exists>\<exists> x. g x) "
proof -
 have 1: "\<turnstile> (f x)  \<longrightarrow> (\<exists>\<exists> x. g x)" using EExI assms lift_imp_trans by blast 
 have 2: "\<turnstile>  \<not>(f x) \<or> (\<exists>\<exists> x. g x)" using "1" by auto
 have 3: "\<turnstile> \<not>(f x) \<longrightarrow> (\<exists>\<exists> x. \<not>(f x))" by (meson EExI)
 have 4: "\<turnstile> (\<exists>\<exists> x. \<not>(f x)) = (\<not>(\<forall>\<forall> x. f x))" using AAxDef by fastforce
 from 2 3 4 show ?thesis by fastforce
qed

lemma EExImpNoDepDist:
 assumes "\<turnstile> f \<longrightarrow> g x"
 shows   "\<turnstile> f \<longrightarrow> (\<exists>\<exists> x. g x)"
using assms by (metis EExI lift_imp_trans)

lemma EExOrDist_1:
 "\<turnstile> (\<exists>\<exists> x. h x) \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x)) "
proof -
 have 1: "\<And> x. \<turnstile> h x \<longrightarrow> f x \<or> h x " by (simp add: Valid_def) 
 have 2: "\<And> x. \<turnstile> f x \<or> h x \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x))"  by (meson EExI)
 have 3: "\<And> x. \<turnstile> h x \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x))" using "1" "2" by (meson lift_imp_trans)
 from 3 show ?thesis using EExE by blast
qed

lemma EExOrDist_2:
 "\<turnstile> (\<exists>\<exists> x. f x) \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x)) "
proof -
 have 1: "\<And> x. \<turnstile> f x \<longrightarrow> f x \<or> h x " by (simp add: Valid_def) 
 have 2: "\<And> x. \<turnstile> f x \<or> h x \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x)) " by (meson EExI)
 have 3: "\<And> x. \<turnstile> f x \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x))" using "1" "2" by (meson lift_imp_trans)    
 from 3 show ?thesis using EExE by blast
qed

lemma EExOrDist_3:
 "\<turnstile> (\<exists>\<exists> x. f x) \<or> (\<exists>\<exists> x. h x) \<longrightarrow> (\<exists>\<exists> x. (f x) \<or> (h x)) "
using EExOrDist_2 EExOrDist_1 by fastforce

lemma EExOrDist_4:
 " \<turnstile> (\<exists>\<exists> x. (f x) \<or> (h x)) \<longrightarrow> (\<exists>\<exists> x. f x) \<or> (\<exists>\<exists> x. h x)"
proof -
 have 1: "\<And> x. \<turnstile> (f x) \<or> (h x) \<longrightarrow> (\<exists>\<exists> x. f x) \<or> (\<exists>\<exists> x. h x) " 
   by (simp add: EExI_unl intI)
 from 1 show ?thesis by (simp add: EExE)
qed

lemma EExOrDist:
 "\<turnstile> ((\<exists>\<exists> x. f x) \<or> (\<exists>\<exists> x. h x)) = (\<exists>\<exists> x. (f x) \<or> (h x))"
using  EExOrDist_3 EExOrDist_4 by fastforce

lemma EExOrImport_1:
 "\<turnstile> g \<longrightarrow> (\<exists>\<exists> x. g \<or> (f x))"
by (simp add: EExI_unl Valid_def)

lemma EExOrImport_2:
 "\<turnstile> (\<exists>\<exists> x. f x) \<longrightarrow> (\<exists>\<exists> x. g \<or> (f x))"
by (simp add: EExOrDist_1)

lemma EExOrImport_3:
 "\<turnstile> (g \<or> (\<exists>\<exists> x. f x)) \<longrightarrow> (\<exists>\<exists> x. g \<or> (f x))"
using EExOrImport_1 EExOrImport_2  by fastforce

lemma EExOrImport_4:
 "\<turnstile> (\<exists>\<exists> x. g \<or> f x) \<longrightarrow> (g \<or> (\<exists>\<exists> x. f x))"
proof -
 have 1: "\<And> x. \<turnstile> g \<or> f x \<longrightarrow> g \<or> (\<exists>\<exists> x. f x)" by (meson EExI int_iffD2 int_simps(27) Prop04 Prop08)
 from 1 show ?thesis by (simp add: EExE)
qed

lemma EExOrImport:
 "\<turnstile> (g \<or> (\<exists>\<exists> x. f x)) = (\<exists>\<exists> x. g \<or> f x)"
by (metis EExOrImport_3 EExOrImport_4 int_iffI)

lemma EExAndImport_1:
 "\<turnstile> g \<and> (\<exists>\<exists> x. f x) \<longrightarrow> (\<exists>\<exists> x. g \<and> f x)"
proof -
 have 1: "\<turnstile> (g \<and> (\<exists>\<exists> x. f x) \<longrightarrow> (\<exists>\<exists> x. g \<and> f x)) = ((\<exists>\<exists> x. f x) \<longrightarrow> (g \<longrightarrow> (\<exists>\<exists> x. g \<and> f x))) "
   by fastforce
 have 2: "\<And> x. \<turnstile> f x \<longrightarrow> (g \<longrightarrow> (\<exists>\<exists> x. g \<and> f x))" 
   using EExI[of "\<lambda>x. LIFT(g \<and> f x)"] by fastforce
 hence 3: "\<turnstile> (\<exists>\<exists> x. f x) \<longrightarrow> (g \<longrightarrow> (\<exists>\<exists> x. g \<and> f x))  " 
   by (simp add: EExE)
 from 1 3 show ?thesis by auto
qed

lemma EExAndImport_2:
 "\<turnstile> (\<exists>\<exists> x. g \<and> f x) \<longrightarrow> g \<and> (\<exists>\<exists> x. f x)"
proof -
 have 1: "\<And> x. \<turnstile> g \<and> f x \<longrightarrow> g \<and> (\<exists>\<exists> x. f x) " 
   by (metis EExI int_iffD2 lift_and_com lift_imp_trans Prop12) 
 from 1 show ?thesis by (simp add: EExE)
qed

lemma EExAndImport:
 "\<turnstile> (g \<and> (\<exists>\<exists> x. f x)) = (\<exists>\<exists> x. g \<and> f x)"
by (simp add: EExAndImport_1 EExAndImport_2 int_iffI)

lemma EExAndDist:
 assumes "\<turnstile> f x \<and> g x"
 shows   "\<turnstile> (\<exists>\<exists> x. f x) \<and> (\<exists>\<exists> x. g x)"
proof -
 have 1: "\<turnstile> f x " using assms by fastforce
 have 2: "\<turnstile> g x " using assms by fastforce
 have 3: "\<turnstile> (\<exists>\<exists> x. f x)" using "1" by (meson EExI MP)  
 have 4: "\<turnstile> (\<exists>\<exists> x. g x)" using "2" by (meson EExI MP) 
 from 3 4 show ?thesis by fastforce
qed

lemma EExAndNoDepDist:
 assumes "\<turnstile> f \<and> g x"
 shows   "\<turnstile> f \<and> (\<exists>\<exists> x. g x)"
proof -
 have 1: "\<turnstile> f " using assms by fastforce
 have 2: "\<turnstile> g x" using assms by fastforce
 have 3: "\<turnstile> (\<exists>\<exists> x. g x)" using "2" by (meson EExI MP)
 from 1 3 show ?thesis by fastforce
qed

lemma Spec:
 "\<turnstile> (\<forall>\<forall> x. f x) \<longrightarrow> f x"
proof -
 have 1: "\<turnstile> \<not>(f x) \<longrightarrow> (\<exists>\<exists> x. \<not>(f x))" by (meson EExI)
 have 2: "\<turnstile> \<not>(\<exists>\<exists> x. \<not>(f x)) \<longrightarrow> f x" using 1 by auto
 from 2 show ?thesis using AAxDef by fastforce
qed

lemma AAxE:
 assumes "\<turnstile> (\<forall>\<forall> x. f x)"
         "\<turnstile> f x \<longrightarrow> g"
 shows   "\<turnstile> g"
using MP Spec assms(1) assms(2) by blast

lemma AAxI:
 assumes "\<And> x. \<turnstile> f x"
 shows   "\<turnstile> (\<forall>\<forall> x. f x)"
using assms by (simp add: Valid_def exist_state_d_def forall_state_d_def)

lemma AAxEqvRule:
 assumes "\<And> x. \<turnstile> f x = g x"
 shows   "\<turnstile> (\<forall>\<forall> x. f x) = (\<forall>\<forall> x. g x)"
 unfolding forall_state_d_def using assms EExEqvRule[of "\<lambda>x. (LIFT(\<not> f x))" "\<lambda>x. (LIFT(\<not>g x))" ]
 by fastforce

lemma AAxAndDist:
 "\<turnstile> (\<forall>\<forall> x. (f x) \<and> (g x)) = ((\<forall>\<forall> x. f x) \<and> (\<forall>\<forall> x. g x))"
proof -
 have 1: "\<And> x . \<turnstile> (\<not>(f x) \<or> \<not>(g x)) = (\<not>((f x) \<and> (g x)))" 
   by auto
 have 2: "\<turnstile> (\<exists>\<exists> x. \<not>(f x) \<or> \<not>(g x)) = (\<exists>\<exists> x. \<not>((f x) \<and> (g x))) " 
   using 1 by (simp add: EExEqvRule)
 have 3: "\<turnstile>(\<exists>\<exists> fa. \<not> (f fa \<and> g fa)) = (\<exists>\<exists> fa. \<not> f fa \<or> \<not> g fa)"
   using 2 by auto
 have 4: "\<turnstile>(\<not> (\<not> (\<exists>\<exists> fa. \<not> f fa) \<and> \<not> (\<exists>\<exists> f. \<not> g f))) = ((\<exists>\<exists> fa. \<not> f fa) \<or> (\<exists>\<exists> f. \<not> g f))"
   by auto 
 have "\<turnstile>((\<exists>\<exists> fa. \<not> f fa) \<or> (\<exists>\<exists> f. \<not> g f)) = (\<exists>\<exists> fa. \<not> f fa \<or> \<not> g fa)"
   by (simp add: EExOrDist inteq_reflection) 
 then have 5: "\<turnstile>(\<not> (\<exists>\<exists> fa. \<not> f fa) \<and> \<not> (\<exists>\<exists> f. \<not> g f)) = (\<not> (\<exists>\<exists> fa. \<not> f fa \<or> \<not> g fa))"
   by auto
 show ?thesis using 3 5 unfolding forall_state_d_def by fastforce
qed


lemma AAxAndImport:
 "\<turnstile> (g \<and> (\<forall>\<forall> x. f x)) = (\<forall>\<forall> x. g \<and> f x)"
proof -
 have 1: "\<turnstile> (\<not> g \<or> (\<exists>\<exists> x. \<not>(f x))) = (\<exists>\<exists> x. \<not> g \<or> \<not>(f x)) " 
   by (simp add: EExOrImport)
 have 2: "\<turnstile> ( (\<exists>\<exists> x. \<not>(f x))) = (\<not>((\<forall>\<forall> x. f x)))" 
   using AAxDef by fastforce 
 have 3: "\<turnstile> ( \<not> g \<or> (\<exists>\<exists> x. \<not>(f x))) = (\<not>(g \<and> (\<forall>\<forall> x. f x)))" 
   using "2" by fastforce
 have 4: "\<And> x. \<turnstile> (\<not> g \<or> \<not>(f x)) = (\<not>(g \<and> f x))" 
   by auto
 have 5: "\<turnstile> (\<exists>\<exists> x. \<not> g \<or> \<not>(f x)) = (\<exists>\<exists> x. \<not>(g \<and> f x))" 
   using "4" by (simp add: EExEqvRule)
 have 6: "\<turnstile> (\<exists>\<exists> x. \<not>(g \<and> f x)) = (\<not>(\<forall>\<forall> x. g \<and> f x))" 
   using AAxDef by fastforce 
 have 7: "\<turnstile> (\<not>(g \<and> (\<forall>\<forall> x. f x))) = (\<not>(\<forall>\<forall> x. g \<and> f x))"
   by (metis "1" "3" "5" "6" inteq_reflection)
 from 7 show ?thesis by fastforce
qed

lemma AAxOrImport:
 "\<turnstile> (g \<or> (\<forall>\<forall> x. f x)) = (\<forall>\<forall> x. g \<or> f x)"
proof -
 have 1: "\<turnstile> (\<not> g \<and> (\<exists>\<exists> x. \<not>(f x))) = (\<exists>\<exists> x. \<not> g \<and> \<not>(f x))" by (simp add: EExAndImport)
 have 2: "\<turnstile> (\<exists>\<exists> x. \<not>(f x)) =  (\<not>((\<forall>\<forall> x. f x)))" using AAxDef by fastforce 
 have 3: "\<turnstile> ( \<not> g \<and> (\<exists>\<exists> x. \<not>(f x))) = (\<not>(g \<or> (\<forall>\<forall> x. f x)))" using "2" by fastforce
 have 4: "\<And> x. \<turnstile> (\<not> g \<and> \<not>(f x)) = (\<not>(g \<or> f x))" by auto
 have 5: "\<turnstile> (\<exists>\<exists> x. \<not> g \<and> \<not>(f x)) = (\<exists>\<exists> x. \<not>(g \<or> f x))" using "4" by (simp add: EExEqvRule)
 have 6: "\<turnstile> (\<exists>\<exists> x. \<not>(g \<or> f x)) = (\<not>(\<forall>\<forall> x. g \<or> f x))" using AAxDef by fastforce 
 have 7: "\<turnstile> (\<not>(g \<or> (\<forall>\<forall> x. f x))) = (\<not>(\<forall>\<forall> x. g \<or> f x))" by (metis "1" "3" "5" "6" inteq_reflection) 
 from 7 show ?thesis by auto
qed

lemma EExImpChopRule:
 assumes "\<turnstile> f x \<longrightarrow> g x"
 shows   "\<turnstile> (\<exists>\<exists> x. h;(f x) \<longrightarrow> h;(g x))"
using RightChopImpChop[of "f x" "g x" "h"]   
      EExImpRule[of "\<lambda>x. LIFT(h;(f x))" "x" "\<lambda>x. LIFT(h;(g x))"]  assms by auto

lemma EExChopRight:
 "\<turnstile> (\<exists>\<exists> x. (f x);g) \<longrightarrow> (\<exists>\<exists> x. f x);g"
proof -
 have 1: "\<And>x. \<turnstile> (f x);g \<longrightarrow> (\<exists>\<exists> x. f x);g" by (simp add: EExI LeftChopImpChop)
 from 1 show ?thesis by (simp add: EExE)
qed

lemma EExChopRightNoDep:
 "\<turnstile> (\<exists>\<exists> x. (f x);g) = (\<exists>\<exists> x. (f x));g"
by (auto simp add: exist_state_d_def Valid_def itl_defs)

lemma EExChopLeft : 
  "\<turnstile> (\<exists>\<exists> x. g;(f x) ) \<longrightarrow> g;(\<exists>\<exists> x. f x)"
proof -
 have 1: "\<And> x. \<turnstile> g;(f x) \<longrightarrow> g;(\<exists>\<exists> x. f x)" by (simp add: EExI RightChopImpChop)
 from 1 show ?thesis by (simp add: EExE)
qed

lemma EExChopLeftNoDep:
 "\<turnstile> (\<exists>\<exists> x. g;(f x) ) = g;(\<exists>\<exists> x. f x)"
by (auto simp add: exist_state_d_def Valid_def itl_defs)

lemma  EExEExChopEqvEExEExChop:
 "\<turnstile> (\<exists>\<exists> v. (\<exists>\<exists> y. (f v);(g y) )) = (\<exists>\<exists> y. (\<exists>\<exists> v. (f v);(g y) )) "
by (simp add: exist_state_d_def Valid_def itl_defs) blast

lemma  EExEExChopEqvEExChopEExA:
 "\<turnstile> (\<exists>\<exists> v. (\<exists>\<exists> y. (f v);(g y) )) = (\<exists>\<exists> v. (f v);(\<exists>\<exists> y. (g y) ) ) "
by (simp add: exist_state_d_def Valid_def itl_defs) blast

lemma EExEExChopEqvEExChopEExB:
 "\<turnstile> (\<exists>\<exists> y. (\<exists>\<exists> v. (f v);(g y) )) = (\<exists>\<exists> y. (\<exists>\<exists> v. (f v)); (g y)) "
by (simp add: exist_state_d_def Valid_def itl_defs) blast

lemma EExEExChopEqvEExChopEExC:
 "\<turnstile> (\<exists>\<exists> v. (\<exists>\<exists> y. (f v);(g y) )) = (\<exists>\<exists> v. (f v));(\<exists>\<exists> y. (g y))"
by (simp add: exist_state_d_def Valid_def itl_defs) blast
 
lemma EExChopDistA: 
 " \<turnstile> (\<exists>\<exists> v. (f v);(g v)) \<longrightarrow> ( \<exists>\<exists> v. (f v)) ; (\<exists>\<exists> v. (g v)) " 
by (simp add: exist_state_d_def Valid_def itl_defs) 
    blast

lemma EExChopDistB: 
 " \<turnstile> ( \<exists>\<exists> v. (f v)) schop (skip schop (\<exists>\<exists> v. (g v))) \<longrightarrow> 
     (\<exists>\<exists> v v1. (f v) schop (skip schop (g v1)))   "
by  (auto simp add: exist_state_d_def Valid_def itl_defs) 

lemma EExChopDistC: 
 " \<turnstile> ( \<exists>\<exists> v. (f v)) schop ( (\<exists>\<exists> v. (g v))) \<longrightarrow> 
     (\<exists>\<exists> v v1. (f v) schop ( (g v1)))   "
by (auto simp add: exist_state_d_def Valid_def itl_defs) 


lemma ExLenOrInf:
 "\<turnstile> (\<exists> n. len(n)) \<or> inf"
using nfinite_nlength_enat by (auto simp add: Valid_def len_defs itl_defs)


lemma CSPowerChop:
 "\<turnstile> (f\<^sup>\<star>) = (\<exists>n. fpower (f \<and> more) n);(empty \<or> (f \<and> more) \<and> inf)"
by (simp add:  chopstar_d_def fpowerstar_d_def powerstar_d_def Valid_def) 

lemma ExChopRightNoDep:
 "\<turnstile> (\<exists> x. (f x);g) = (\<exists> x. (f x));g"
by (auto simp add: Valid_def itl_defs)

lemma ExChopLeftNoDep:
 "\<turnstile> (\<exists> x. g;(f x) ) = g;(\<exists> x. f x)"
by (auto simp add: Valid_def itl_defs)

lemma ExExEqvExEx:
 "\<turnstile> (\<exists> x. (\<exists> y. (f x);(g y))) = (\<exists> y. (\<exists> x. (f x);(g y)))"
by (auto simp add: Valid_def itl_defs)


end
